/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.aop;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.aop.JMX;
import org.smallmind.instrument.aop.MetricSupplier;
import org.smallmind.nutsnbolts.reflection.aop.AOPUtility;

public abstract class MetricAspect {
    private static final MetricRegistry METRIC_REGISTRY = InstrumentationManager.getMetricRegistry();

    static {
        if (METRIC_REGISTRY == null) {
            throw new ExceptionInInitializerError("No MetricRegistry instance has been registered with the MetricRegistryFactory");
        }
    }

    public Object engage(ProceedingJoinPoint thisJoinPoint, JMX jmx, String alias, Metrics.MetricBuilder<?> metricBuilder) throws Throwable {
        MetricProperty[] properties = new MetricProperty[jmx.properties().length];
        int index = 0;
        while (index < properties.length) {
            properties[index] = new MetricProperty(jmx.properties()[index].key(), jmx.properties()[index].constant() ? jmx.properties()[index].value() : AOPUtility.getParameterValue((JoinPoint)thisJoinPoint, (String)jmx.properties()[index].value(), (boolean)false).toString());
            ++index;
        }
        Object metric = METRIC_REGISTRY.instrument(metricBuilder, jmx.domain(), properties);
        String supplierKey = alias.length() == 0 ? null : alias;
        MetricSupplier.push(supplierKey, metric);
        try {
            Object object = thisJoinPoint.proceed();
            return object;
        }
        finally {
            MetricSupplier.pop(supplierKey);
        }
    }
}

