/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.context;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.smallmind.instrument.context.MetricAddress;
import org.smallmind.instrument.context.MetricSnapshot;
import org.smallmind.instrument.context.TracingOptions;

public class MetricContext {
    private final TracingOptions tracingOptions;
    private final ConcurrentLinkedDeque<MetricSnapshot> arabesqueQueue = new ConcurrentLinkedDeque();
    private final LinkedList<MetricSnapshot> outputList = new LinkedList();
    private final long startTime;

    public MetricContext(TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
        this.startTime = System.currentTimeMillis();
    }

    public boolean hasAged() {
        long minimumLiveSeconds = this.tracingOptions.getMinimumLiveMilliseconds();
        return minimumLiveSeconds >= 0L && System.currentTimeMillis() - this.startTime >= minimumLiveSeconds;
    }

    public void append(MetricContext metricContext) {
        List<MetricSnapshot> appendList;
        if (this != metricContext && (appendList = metricContext.getSnapshots()) != null && !appendList.isEmpty()) {
            this.outputList.addAll(appendList);
        }
    }

    public boolean pushSnapshot(MetricAddress metricAddress) {
        MetricSnapshot metricSnapshot = new MetricSnapshot(metricAddress, this.tracingOptions);
        this.arabesqueQueue.addFirst(metricSnapshot);
        this.outputList.addLast(metricSnapshot);
        return true;
    }

    public void popSnapshot() {
        if (!this.arabesqueQueue.isEmpty()) {
            this.arabesqueQueue.removeFirst();
        }
    }

    public MetricSnapshot getSnapshot() {
        if (this.arabesqueQueue.isEmpty()) {
            return null;
        }
        return this.arabesqueQueue.getFirst();
    }

    public boolean isEmpty() {
        if (this.outputList.isEmpty()) {
            return true;
        }
        for (MetricSnapshot snapshot : this.outputList) {
            if (snapshot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<MetricSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.outputList);
    }

    public String toString() {
        StringBuilder contextBuilder = new StringBuilder();
        boolean firstContext = true;
        contextBuilder.append(System.currentTimeMillis() - this.startTime).append('-');
        for (MetricSnapshot snapshot : this.outputList) {
            if (snapshot.isEmpty()) continue;
            if (!firstContext) {
                contextBuilder.append(',');
            }
            contextBuilder.append('[').append(snapshot).append(']');
            firstContext = false;
        }
        return contextBuilder.toString();
    }
}

