/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.smallmind.instrument.Sample;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Statistics;

public class UniformSample
implements Sample {
    private static final int BITS_PER_LONG = 63;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public UniformSample(int reservoirSize) {
        this.values = new AtomicLongArray(reservoirSize);
        this.clear();
    }

    @Override
    public Samples getType() {
        return Samples.UNIFORM;
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.values.length()) {
            this.values.set(i, 0L);
            ++i;
        }
        this.count.set(0L);
    }

    @Override
    public int size() {
        long currentCount = this.count.get();
        return currentCount > (long)this.values.length() ? this.values.length() : (int)currentCount;
    }

    @Override
    public void update(long value) {
        long updatedCount = this.count.incrementAndGet();
        if (updatedCount <= (long)this.values.length()) {
            this.values.set((int)updatedCount - 1, value);
        } else {
            long randomLong = this.nextLong(updatedCount);
            if (randomLong < (long)this.values.length()) {
                this.values.set((int)randomLong, value);
            }
        }
    }

    private long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public Statistics getStatistics() {
        int currentSize = this.size();
        ArrayList<Long> copy = new ArrayList<Long>(currentSize);
        int i = 0;
        while (i < currentSize) {
            copy.add(this.values.get(i));
            ++i;
        }
        return new Statistics(copy);
    }
}

