/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.instrument.MetricImpl;
import org.smallmind.instrument.Tally;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.MetricSnapshot;

public class TallyImpl
extends MetricImpl<Tally>
implements Tally {
    private final AtomicLong count;

    public TallyImpl() {
        this(0);
    }

    public TallyImpl(int initialCount) {
        this.count = new AtomicLong(initialCount);
    }

    @Override
    public Class<Tally> getMetricClass() {
        return Tally.class;
    }

    @Override
    public void clear() {
        this.count.set(0L);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            metricSnapshot.addItem(new MetricItem<Long>("count", 0L));
        }
    }

    @Override
    public void inc() {
        long current = this.count.incrementAndGet();
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            metricSnapshot.addItem(new MetricItem<Long>("count", current));
        }
    }

    @Override
    public void inc(long n) {
        long current = this.count.addAndGet(n);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            metricSnapshot.addItem(new MetricItem<Long>("count", current));
        }
    }

    @Override
    public void dec() {
        long current = this.count.decrementAndGet();
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null && metricSnapshot.willTrace(MetricFact.COUNT)) {
            metricSnapshot.addItem(new MetricItem<Long>("count", current));
        }
    }

    @Override
    public void dec(long n) {
        long current = this.count.addAndGet(0L - n);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null && metricSnapshot.willTrace(MetricFact.COUNT)) {
            metricSnapshot.addItem(new MetricItem<Long>("count", current));
        }
    }

    @Override
    public long getCount() {
        return this.count.get();
    }
}

