/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Gauge;
import org.smallmind.instrument.GaugeImpl;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.HistogramImpl;
import org.smallmind.instrument.InstrumentationException;
import org.smallmind.instrument.MetricImpl;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Statistics;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.MetricSnapshot;

public class ChronometerImpl
extends MetricImpl<Chronometer>
implements Chronometer {
    private final Histogram histogram;
    private final Gauge gauge;
    private final TimeUnit durationTimeUnit;

    public ChronometerImpl(Samples samples, TimeUnit durationTimeUnit, long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.durationTimeUnit = durationTimeUnit;
        this.gauge = (Gauge)new GaugeImpl(tickInterval, tickTimeUnit, clock).setName("gauge");
        this.histogram = (Histogram)new HistogramImpl(samples).setName("histogram");
    }

    @Override
    public Class<Chronometer> getMetricClass() {
        return Chronometer.class;
    }

    @Override
    public void clear() {
        this.gauge.clear();
        this.histogram.clear();
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null && metricSnapshot.willTrace(MetricFact.DURATION)) {
            metricSnapshot.addItem(new MetricItem<Long>("duration", 0L));
        }
    }

    @Override
    public void update(long duration) {
        if (duration < 0L) {
            throw new InstrumentationException("Chronometer durations must be >= 0", new Object[0]);
        }
        this.histogram.update(duration);
        this.gauge.mark();
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null && metricSnapshot.willTrace(MetricFact.DURATION)) {
            metricSnapshot.addItem(new MetricItem<Long>("duration", duration));
        }
    }

    @Override
    public String getSampleType() {
        return this.histogram.getSampleType();
    }

    @Override
    public Clock getClock() {
        return this.gauge.getClock();
    }

    @Override
    public TimeUnit getLatencyTimeUnit() {
        return this.durationTimeUnit;
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.gauge.getRateTimeUnit();
    }

    @Override
    public long getCount() {
        return this.gauge.getCount();
    }

    @Override
    public double getOneMinuteAvgRate() {
        return this.gauge.getOneMinuteAvgRate();
    }

    @Override
    public double getFiveMinuteAvgRate() {
        return this.gauge.getFiveMinuteAvgRate();
    }

    @Override
    public double getFifteenMinuteAvgRate() {
        return this.gauge.getFifteenMinuteAvgRate();
    }

    @Override
    public double getAverageRate() {
        return this.gauge.getAverageRate();
    }

    @Override
    public double getMax() {
        return this.histogram.getMax();
    }

    @Override
    public double getMin() {
        return this.histogram.getMin();
    }

    @Override
    public double getAverage() {
        return this.histogram.getAverage();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDev();
    }

    @Override
    public double getSum() {
        return this.histogram.getSum();
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(this.histogram.getStatistics().getValues());
    }

    @Override
    public void stop() {
        this.gauge.stop();
    }
}

