/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.instrument.context.TracingOptions;
import org.smallmind.nutsnbolts.lang.PerApplicationContext;
import org.smallmind.nutsnbolts.lang.PerApplicationDataManager;
import org.smallmind.scribe.pen.LoggerManager;

public class InstrumentationManager
implements PerApplicationDataManager {
    private static final ThreadLocal<MetricContext> METRIC_CONTEXT_LOCAL = new ThreadLocal();

    public static void register(MetricRegistry metricRegistry) {
        PerApplicationContext.setPerApplicationData(InstrumentationManager.class, (Object)metricRegistry);
    }

    public static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)PerApplicationContext.getPerApplicationData(InstrumentationManager.class, MetricRegistry.class);
    }

    public static MetricContext getMetricContext() {
        return METRIC_CONTEXT_LOCAL.get();
    }

    public static void setMetricContext(MetricContext metricContext) {
        METRIC_CONTEXT_LOCAL.set(metricContext);
    }

    /*
     * WARNING - void declaration
     */
    public static void createMetricContext() {
        void var1_1;
        TracingOptions tracingOptions;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        InstrumentationManager.setMetricContext(new MetricContext((TracingOptions)(metricRegistry == null ? null : ((tracingOptions = metricRegistry.getTracingOptions()) == null ? null : var1_1))));
    }

    public static void appendMetricContext(MetricContext appendedMetricContext) {
        MetricContext currentMetricContext = METRIC_CONTEXT_LOCAL.get();
        if (currentMetricContext != null) {
            currentMetricContext.append(appendedMetricContext);
        }
    }

    public static MetricContext removeMetricContext() {
        MetricContext metricContext = METRIC_CONTEXT_LOCAL.get();
        METRIC_CONTEXT_LOCAL.remove();
        return metricContext;
    }

    public static void publishMetricContext() {
        MetricContext metricContext = InstrumentationManager.removeMetricContext();
        if (metricContext != null && metricContext.hasAged() && !metricContext.isEmpty()) {
            LoggerManager.getLogger(MetricContext.class).info((Object)metricContext);
        }
    }

    public static <M extends Metric<M>> void execute(Instrument<M> instrument) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        instrument.with(metricRegistry == null || (arguments = instrument.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static <M extends Metric<M>, T> T execute(InstrumentAndReturn<M, T> instrumentAndReturn) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        return instrumentAndReturn.with(metricRegistry == null || (arguments = instrumentAndReturn.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static void instrumentWithTally(MetricConfigurationProvider provider, MetricProperty ... properties) {
        InstrumentationManager.instrumentWithTally(provider, 1L, properties);
    }

    public static void instrumentWithTally(MetricConfigurationProvider provider, long count, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildTally(0), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).inc(count);
        }
    }

    public static void instrumentWithGauge(MetricConfigurationProvider provider, MetricProperty ... properties) {
        InstrumentationManager.instrumentWithGauge(provider, 1L, properties);
    }

    public static void instrumentWithGauge(MetricConfigurationProvider provider, long quantity, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildGauge(provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).mark(quantity);
        }
    }

    public static void instrumentWithHistogram(MetricConfigurationProvider provider, long value, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildHistogram(provider.getMetricConfiguration().getSamples()), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).update(value);
        }
    }

    public static void instrumentWithSpeedometer(MetricConfigurationProvider provider, long quantity, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildSpeedometer(provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties).update(quantity);
        }
    }

    public static void instrumentWithChronometer(MetricConfigurationProvider provider, long duration, TimeUnit durationTimeUnit, MetricProperty ... properties) {
        if (provider != null && provider.getMetricConfiguration() != null && provider.getMetricConfiguration().isInstrumented()) {
            Chronometer chronometer = InstrumentationManager.getMetricRegistry().instrument(Metrics.buildChronometer(provider.getMetricConfiguration().getSamples(), TimeUnit.MILLISECONDS, provider.getMetricConfiguration().getTickInterval(), provider.getMetricConfiguration().getTickTimeUnit(), Clocks.EPOCH), provider.getMetricConfiguration().getMetricDomain().getDomain(), properties);
            chronometer.update(chronometer.getLatencyTimeUnit().convert(duration, durationTimeUnit));
        }
    }
}

