/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Gauge;
import org.smallmind.instrument.GaugeImpl;
import org.smallmind.instrument.MetricImpl;
import org.smallmind.instrument.Speedometer;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.MetricSnapshot;

public class SpeedometerImpl
extends MetricImpl<Speedometer>
implements Speedometer {
    private final Gauge rateGauge;
    private final Gauge quantityGauge;
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

    public SpeedometerImpl(long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.rateGauge = (Gauge)new GaugeImpl(tickInterval, tickTimeUnit, clock).setName("rate");
        this.quantityGauge = (Gauge)new GaugeImpl(tickInterval, tickTimeUnit, clock).setName("quantity");
    }

    @Override
    public Class<Speedometer> getMetricClass() {
        return Speedometer.class;
    }

    @Override
    public void clear() {
        this.rateGauge.clear();
        this.quantityGauge.clear();
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            if (metricSnapshot.willTrace(MetricFact.MIN)) {
                metricSnapshot.addItem(new MetricItem<String>("min", "n/a"));
            }
            if (metricSnapshot.willTrace(MetricFact.MAX)) {
                metricSnapshot.addItem(new MetricItem<String>("max", "n/a"));
            }
        }
    }

    @Override
    public void update() {
        this.update(1L);
    }

    @Override
    public void update(long quantity) {
        this.rateGauge.mark();
        this.quantityGauge.mark(quantity);
        long currentMin = this.setMin(quantity);
        long currentMax = this.setMax(quantity);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            if (metricSnapshot.willTrace(MetricFact.MIN)) {
                metricSnapshot.addItem(new MetricItem<Long>("min", currentMin));
            }
            if (metricSnapshot.willTrace(MetricFact.MAX)) {
                metricSnapshot.addItem(new MetricItem<Long>("max", currentMax));
            }
        }
    }

    @Override
    public Clock getClock() {
        return this.rateGauge.getClock();
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.rateGauge.getRateTimeUnit();
    }

    @Override
    public long getCount() {
        return this.rateGauge.getCount();
    }

    @Override
    public double getOneMinuteAvgRate() {
        return this.rateGauge.getOneMinuteAvgRate();
    }

    @Override
    public double getOneMinuteAvgVelocity() {
        return this.quantityGauge.getOneMinuteAvgRate() / this.rateGauge.getOneMinuteAvgRate();
    }

    @Override
    public double getFiveMinuteAvgRate() {
        return this.rateGauge.getFiveMinuteAvgRate();
    }

    @Override
    public double getFiveMinuteAvgVelocity() {
        return this.quantityGauge.getFiveMinuteAvgRate() / this.rateGauge.getFiveMinuteAvgRate();
    }

    @Override
    public double getFifteenMinuteAvgRate() {
        return this.rateGauge.getFifteenMinuteAvgRate();
    }

    @Override
    public double getFifteenMinuteAvgVelocity() {
        return this.quantityGauge.getFifteenMinuteAvgRate() / this.rateGauge.getFifteenMinuteAvgRate();
    }

    @Override
    public double getAverageRate() {
        return this.rateGauge.getAverageRate();
    }

    @Override
    public double getAverageVelocity() {
        return this.quantityGauge.getAverageRate() / this.rateGauge.getAverageRate();
    }

    @Override
    public double getMax() {
        return this.getCount() > 0L ? (double)this.max.get() : 0.0;
    }

    private long setMax(long potentialMax) {
        long currentMax;
        boolean replaced = false;
        while ((currentMax = this.max.get()) < potentialMax && !(replaced = this.max.compareAndSet(currentMax, potentialMax))) {
        }
        return replaced ? potentialMax : currentMax;
    }

    @Override
    public double getMin() {
        return this.getCount() > 0L ? (double)this.min.get() : 0.0;
    }

    private long setMin(long potentialMin) {
        long currentMin;
        boolean replaced = false;
        while ((currentMin = this.min.get()) > potentialMin && !(replaced = this.min.compareAndSet(currentMin, potentialMin))) {
        }
        return replaced ? potentialMin : currentMin;
    }

    @Override
    public void stop() {
        this.rateGauge.stop();
        this.quantityGauge.stop();
    }
}

