/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.context;

import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Gauge;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricType;
import org.smallmind.instrument.Speedometer;
import org.smallmind.instrument.Tally;
import org.smallmind.instrument.context.ChronometerNamedMetric;
import org.smallmind.instrument.context.GaugeNamedMetric;
import org.smallmind.instrument.context.HistogramNamedMetric;
import org.smallmind.instrument.context.NamedMetric;
import org.smallmind.instrument.context.SpeedometerNamedMetric;
import org.smallmind.instrument.context.TallyNamedMetric;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;

public class NamedMetricFactory {
    public static NamedMetric createNamedMetric(MetricType metricType, Metric metric, String domain, MetricProperty ... properties) {
        switch (metricType) {
            case TALLY: {
                return new TallyNamedMetric((Tally)metric, domain, properties);
            }
            case METER: {
                return new GaugeNamedMetric((Gauge)metric, domain, properties);
            }
            case HISTOGRAM: {
                return new HistogramNamedMetric((Histogram)metric, domain, properties);
            }
            case SPEEDOMETER: {
                return new SpeedometerNamedMetric((Speedometer)metric, domain, properties);
            }
            case CHRONOMETER: {
                return new ChronometerNamedMetric((Chronometer)metric, domain, properties);
            }
        }
        throw new UnknownSwitchCaseException(metricType.name(), new Object[0]);
    }
}

