/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.config.MetricConfiguration;

public abstract class ChronometerInstrumentAndReturn<T>
extends InstrumentAndReturn<Chronometer, T> {
    public ChronometerInstrumentAndReturn(MetricConfiguration configuration, MetricProperty ... properties) {
        super(configuration == null || !configuration.isInstrumented() ? null : new InstrumentationArguments<Chronometer>(Metrics.buildChronometer(configuration.getSamples(), TimeUnit.MILLISECONDS, configuration.getTickInterval(), configuration.getTickTimeUnit()), configuration.getMetricDomain().getDomain(), properties));
    }

    public ChronometerInstrumentAndReturn(Metrics.MetricBuilder<Chronometer> builder, String domain, MetricProperty ... properties) {
        super(new InstrumentationArguments<Chronometer>(builder, domain, properties));
    }

    public abstract T withChronometer() throws Throwable;

    @Override
    public final T with(Chronometer chronometer) throws Throwable {
        long startTime = 0L;
        if (chronometer != null) {
            startTime = chronometer.getClock().getTimeNanoseconds();
        }
        T result = this.withChronometer();
        if (chronometer != null) {
            chronometer.update(chronometer.getLatencyTimeUnit().convert(chronometer.getClock().getTimeNanoseconds() - startTime, TimeUnit.NANOSECONDS));
        }
        return result;
    }
}

