/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Gauge;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.InstrumentationException;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricKey;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.Speedometer;
import org.smallmind.instrument.Tally;
import org.smallmind.instrument.context.NamedMetricFactory;
import org.smallmind.instrument.context.TracingOptions;
import org.smallmind.instrument.event.MetricEvent;
import org.smallmind.instrument.event.MetricEventListener;
import org.smallmind.instrument.jmx.ChronometerMonitor;
import org.smallmind.instrument.jmx.DefaultJMXNamingPolicy;
import org.smallmind.instrument.jmx.GaugeMonitor;
import org.smallmind.instrument.jmx.HistogramMonitor;
import org.smallmind.instrument.jmx.JMXNamingPolicy;
import org.smallmind.instrument.jmx.SpeedometerMonitor;
import org.smallmind.instrument.jmx.TallyMonitor;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;

public class MetricRegistry {
    private final ConcurrentHashMap<MetricKey, Metric<?>> metricMap = new ConcurrentHashMap();
    private MBeanServer server;
    private JMXNamingPolicy jmxNamingPolicy = new DefaultJMXNamingPolicy();
    private TracingOptions tracingOptions;
    private ConcurrentLinkedQueue<MetricEventListener> metricEventListenerQueue = new ConcurrentLinkedQueue();

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setJmxNamingPolicy(JMXNamingPolicy jmxNamingPolicy) {
        this.jmxNamingPolicy = jmxNamingPolicy;
    }

    public TracingOptions getTracingOptions() {
        return this.tracingOptions;
    }

    public void setTracingOptions(TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
    }

    public void setMetricEventListeners(MetricEventListener[] metricEventListeners) {
        this.metricEventListenerQueue.addAll(Arrays.asList(metricEventListeners));
    }

    public void register() {
        InstrumentationManager.register(this);
    }

    public void addMetricEventListener(MetricEventListener metricEventListener) {
        this.metricEventListenerQueue.add(metricEventListener);
    }

    public void removeMetricEventListener(MetricEventListener metricEventListener) {
        this.metricEventListenerQueue.remove(metricEventListener);
    }

    public void fireMetricEvent(MetricEvent metricEvent) {
        if (!this.metricEventListenerQueue.isEmpty()) {
            for (MetricEventListener metricEventListener : this.metricEventListenerQueue) {
                metricEventListener.metricTriggered(metricEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Metric<M>> M instrument(Metrics.MetricBuilder<M> builder, String domain, MetricProperty ... properties) {
        MetricKey metricKey = new MetricKey(builder.getType(), domain, properties);
        Metric metric = (Metric)builder.getMetricClass().cast(this.metricMap.get(metricKey));
        if (metric == null) {
            ConcurrentHashMap<MetricKey, Metric<?>> concurrentHashMap = this.metricMap;
            synchronized (concurrentHashMap) {
                metric = (Metric)builder.getMetricClass().cast(this.metricMap.get(metricKey));
                if (metric == null) {
                    metric = this.tracingOptions != null ? (Metric)builder.getMetricClass().cast(NamedMetricFactory.createNamedMetric(builder.getType(), builder.construct(), domain, properties).getProxy()) : builder.construct();
                    this.metricMap.put(metricKey, metric);
                    if (this.server != null) {
                        StandardMBean mBean;
                        switch (builder.getType()) {
                            case TALLY: {
                                mBean = new TallyMonitor((Tally)metric);
                                break;
                            }
                            case METER: {
                                mBean = new GaugeMonitor((Gauge)metric);
                                break;
                            }
                            case HISTOGRAM: {
                                mBean = new HistogramMonitor((Histogram)metric);
                                break;
                            }
                            case SPEEDOMETER: {
                                mBean = new SpeedometerMonitor((Speedometer)metric);
                                break;
                            }
                            case CHRONOMETER: {
                                mBean = new ChronometerMonitor((Chronometer)metric);
                                break;
                            }
                            default: {
                                throw new UnknownSwitchCaseException(builder.getType().name(), new Object[0]);
                            }
                        }
                        try {
                            this.server.registerMBean(mBean, this.jmxNamingPolicy.createObjectName(builder.getType(), domain, properties));
                        }
                        catch (Exception exception) {
                            throw new InstrumentationException(exception);
                        }
                    }
                }
            }
        }
        return (M)metric;
    }
}

