/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.instrument.context.TracingOptions;
import org.smallmind.nutsnbolts.lang.PerApplicationContext;
import org.smallmind.nutsnbolts.lang.PerApplicationDataManager;
import org.smallmind.scribe.pen.LoggerManager;

public class InstrumentationManager
implements PerApplicationDataManager {
    private static final ThreadLocal<MetricContext> METRIC_CONTEXT_LOCAL = new ThreadLocal();

    public static void register(MetricRegistry metricRegistry) {
        PerApplicationContext.setPerApplicationData(InstrumentationManager.class, (Object)metricRegistry);
    }

    public static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)PerApplicationContext.getPerApplicationData(InstrumentationManager.class, MetricRegistry.class);
    }

    public static MetricContext getMetricContext() {
        return METRIC_CONTEXT_LOCAL.get();
    }

    public static void setMetricContext(MetricContext metricContext) {
        METRIC_CONTEXT_LOCAL.set(metricContext);
    }

    /*
     * WARNING - void declaration
     */
    public static void createMetricContext() {
        void var1_1;
        TracingOptions tracingOptions;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        InstrumentationManager.setMetricContext(new MetricContext((TracingOptions)(metricRegistry == null ? null : ((tracingOptions = metricRegistry.getTracingOptions()) == null ? null : var1_1))));
    }

    public static void appendMetricContext(MetricContext appendedMetricContext) {
        MetricContext currentMetricContext = METRIC_CONTEXT_LOCAL.get();
        if (currentMetricContext != null) {
            currentMetricContext.append(appendedMetricContext);
        }
    }

    public static MetricContext removeMetricContext() {
        MetricContext metricContext = METRIC_CONTEXT_LOCAL.get();
        METRIC_CONTEXT_LOCAL.remove();
        return metricContext;
    }

    public static void publishMetricContext() {
        MetricContext metricContext = InstrumentationManager.removeMetricContext();
        if (metricContext != null && metricContext.hasAged() && !metricContext.isEmpty()) {
            LoggerManager.getLogger(MetricContext.class).info((Object)metricContext);
        }
    }

    public static <M extends Metric<M>> void execute(Instrument<M> instrument) throws Exception {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        instrument.with(metricRegistry == null || (arguments = instrument.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static <M extends Metric<M>, T> T execute(InstrumentAndReturn<M, T> instrumentAndReturn) throws Throwable {
        InstrumentationArguments<M> arguments;
        MetricRegistry metricRegistry = InstrumentationManager.getMetricRegistry();
        return instrumentAndReturn.with(metricRegistry == null || (arguments = instrumentAndReturn.getArguments()) == null ? null : (Object)metricRegistry.instrument(arguments.getBuilder(), arguments.getDomain(), arguments.getProperties()));
    }

    public static void instrumentWithTally(MetricConfiguration configuration, MetricProperty ... properties) {
        InstrumentationManager.instrumentWithTally(configuration, 1L, properties);
    }

    public static void instrumentWithTally(MetricConfiguration configuration, long count, MetricProperty ... properties) {
        if (configuration != null && configuration != null && configuration.isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildTally(0), configuration.getMetricDomain().getDomain(), properties).inc(count);
        }
    }

    public static void instrumentWithGauge(MetricConfiguration configuration, MetricProperty ... properties) {
        InstrumentationManager.instrumentWithGauge(configuration, 1L, properties);
    }

    public static void instrumentWithGauge(MetricConfiguration configuration, long quantity, MetricProperty ... properties) {
        if (configuration != null && configuration != null && configuration.isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildGauge(configuration.getTickInterval(), configuration.getTickTimeUnit(), Clocks.EPOCH), configuration.getMetricDomain().getDomain(), properties).mark(quantity);
        }
    }

    public static void instrumentWithHistogram(MetricConfiguration configuration, long value, MetricProperty ... properties) {
        if (configuration != null && configuration != null && configuration.isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildHistogram(configuration.getSamples()), configuration.getMetricDomain().getDomain(), properties).update(value);
        }
    }

    public static void instrumentWithSpeedometer(MetricConfiguration configuration, long quantity, MetricProperty ... properties) {
        if (configuration != null && configuration != null && configuration.isInstrumented()) {
            InstrumentationManager.getMetricRegistry().instrument(Metrics.buildSpeedometer(configuration.getTickInterval(), configuration.getTickTimeUnit(), Clocks.EPOCH), configuration.getMetricDomain().getDomain(), properties).update(quantity);
        }
    }

    public static void instrumentWithChronometer(MetricConfiguration configuration, long duration, TimeUnit durationTimeUnit, MetricProperty ... properties) {
        if (configuration != null && configuration != null && configuration.isInstrumented()) {
            Chronometer chronometer = InstrumentationManager.getMetricRegistry().instrument(Metrics.buildChronometer(configuration.getSamples(), TimeUnit.MILLISECONDS, configuration.getTickInterval(), configuration.getTickTimeUnit(), Clocks.EPOCH), configuration.getMetricDomain().getDomain(), properties);
            chronometer.update(chronometer.getLatencyTimeUnit().convert(duration, durationTimeUnit));
        }
    }
}

