/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.MetricImpl;
import org.smallmind.instrument.Sample;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Statistics;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.MetricSnapshot;

public class HistogramImpl
extends MetricImpl<Histogram>
implements Histogram {
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicReference<double[]> variance = new AtomicReference<double[]>(new double[]{-1.0, 0.0});
    private final AtomicLong count = new AtomicLong(0L);
    private final ArrayCache arrayCache = new ArrayCache();
    private final Sample sample;
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong sum = new AtomicLong(0L);

    public HistogramImpl(Samples samples) {
        this.sample = samples.createSample();
    }

    @Override
    public Class<Histogram> getMetricClass() {
        return Histogram.class;
    }

    @Override
    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this.sum.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
        this.variance.set(new double[]{-1.0, 0.0});
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            if (metricSnapshot.willTrace(MetricFact.COUNT)) {
                metricSnapshot.addItem(new MetricItem<Long>("count", 0L));
            }
            if (metricSnapshot.willTrace(MetricFact.SUM)) {
                metricSnapshot.addItem(new MetricItem<Long>("sum", 0L));
            }
            if (metricSnapshot.willTrace(MetricFact.MIN)) {
                metricSnapshot.addItem(new MetricItem<String>("min", "n/a"));
            }
            if (metricSnapshot.willTrace(MetricFact.MAX)) {
                metricSnapshot.addItem(new MetricItem<String>("max", "n/a"));
            }
            if (metricSnapshot.willTrace(MetricFact.AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("avg", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.STD_DEV)) {
                metricSnapshot.addItem(new MetricItem<Double>("std dev", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.MEDIAN)) {
                metricSnapshot.addItem(new MetricItem<Double>("median", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.P75_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("75th pctl", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.P95_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("95th pctl", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.P98_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("98th pctl", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.P99_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("99th pctl", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.P999_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("999th pctl", 0.0));
            }
        }
    }

    @Override
    public void update(long value) {
        long currentCount = this.count.incrementAndGet();
        long currentSum = this.sum.getAndAdd(value);
        long currentMin = this.setMin(value);
        long currentMax = this.setMax(value);
        double[] currentValues = this.updateVariance(value);
        this.sample.update(value);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            Statistics currentStatistics = this.sample.getStatistics();
            if (metricSnapshot.willTrace(MetricFact.COUNT)) {
                metricSnapshot.addItem(new MetricItem<Long>("count", currentCount));
            }
            if (metricSnapshot.willTrace(MetricFact.SUM)) {
                metricSnapshot.addItem(new MetricItem<Long>("sum", currentSum));
            }
            if (metricSnapshot.willTrace(MetricFact.MIN)) {
                metricSnapshot.addItem(new MetricItem<Long>("min", currentMin));
            }
            if (metricSnapshot.willTrace(MetricFact.MAX)) {
                metricSnapshot.addItem(new MetricItem<Long>("max", currentMax));
            }
            if (metricSnapshot.willTrace(MetricFact.AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("avg", currentCount > 0L ? (double)currentSum / (double)currentCount : 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.STD_DEV)) {
                metricSnapshot.addItem(new MetricItem<Double>("std dev", currentCount > 0L ? Math.sqrt(currentCount <= 1L ? 0.0 : currentValues[1] / (double)(currentCount - 1L)) : 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.MEDIAN)) {
                metricSnapshot.addItem(new MetricItem<Double>("median", currentStatistics.getMedian()));
            }
            if (metricSnapshot.willTrace(MetricFact.P75_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("75th pctl", currentStatistics.get75thPercentile()));
            }
            if (metricSnapshot.willTrace(MetricFact.P95_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("95th pctl", currentStatistics.get95thPercentile()));
            }
            if (metricSnapshot.willTrace(MetricFact.P98_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("98th pctl", currentStatistics.get98thPercentile()));
            }
            if (metricSnapshot.willTrace(MetricFact.P99_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("99th pctl", currentStatistics.get99thPercentile()));
            }
            if (metricSnapshot.willTrace(MetricFact.P999_Q)) {
                metricSnapshot.addItem(new MetricItem<Double>("999th pctl", currentStatistics.get999thPercentile()));
            }
        }
    }

    @Override
    public String getSampleType() {
        return this.sample.getType().name();
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public double getMax() {
        return this.getCount() > 0L ? (double)this.max.get() : 0.0;
    }

    private long setMax(long potentialMax) {
        long currentMax;
        boolean replaced = false;
        while ((currentMax = this.max.get()) < potentialMax && !(replaced = this.max.compareAndSet(currentMax, potentialMax))) {
        }
        return replaced ? potentialMax : currentMax;
    }

    @Override
    public double getMin() {
        return this.getCount() > 0L ? (double)this.min.get() : 0.0;
    }

    private long setMin(long potentialMin) {
        long currentMin;
        boolean replaced = false;
        while ((currentMin = this.min.get()) > potentialMin && !(replaced = this.min.compareAndSet(currentMin, potentialMin))) {
        }
        return replaced ? potentialMin : currentMin;
    }

    @Override
    public double getAverage() {
        return this.getCount() > 0L ? (double)this.sum.get() / (double)this.getCount() : 0.0;
    }

    @Override
    public double getStdDev() {
        return this.getCount() > 0L ? Math.sqrt(this.getVariance()) : 0.0;
    }

    @Override
    public double getSum() {
        return this.sum.get();
    }

    private double getVariance() {
        return this.getCount() <= 1L ? 0.0 : this.variance.get()[1] / (double)(this.getCount() - 1L);
    }

    @Override
    public Statistics getStatistics() {
        return this.sample.getStatistics();
    }

    private double[] updateVariance(long value) {
        double[] newValues;
        boolean done;
        do {
            double[] oldValues = this.variance.get();
            newValues = (double[])this.arrayCache.get();
            if (oldValues[0] == -1.0) {
                newValues[0] = value;
                newValues[1] = 0.0;
            } else {
                double oldM = oldValues[0];
                double oldS = oldValues[1];
                double newM = oldM + ((double)value - oldM) / (double)this.getCount();
                double newS = oldS + ((double)value - oldM) * ((double)value - newM);
                newValues[0] = newM;
                newValues[1] = newS;
            }
            done = this.variance.compareAndSet(oldValues, newValues);
            if (!done) continue;
            this.arrayCache.set(oldValues);
        } while (!done);
        return newValues;
    }

    private static final class ArrayCache
    extends ThreadLocal<double[]> {
        private ArrayCache() {
        }

        @Override
        protected double[] initialValue() {
            return new double[2];
        }
    }
}

