/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.context;

import java.io.Serializable;
import java.util.LinkedList;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.context.MetricAddress;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.TracingOptions;

public class MetricSnapshot
implements Serializable {
    private TracingOptions tracingOptions;
    private LinkedList<MetricItem> itemList;
    private MetricProperty[] properties;
    private String domain;

    public MetricSnapshot(MetricAddress metricAddress, TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
        this.domain = metricAddress.getDomain();
        this.properties = metricAddress.getProperties();
        this.itemList = new LinkedList();
    }

    public String getDomain() {
        return this.domain;
    }

    public MetricProperty[] getProperties() {
        return this.properties;
    }

    public boolean willTrace(MetricFact fact) {
        return this.tracingOptions != null && this.tracingOptions.contains(fact);
    }

    public boolean isEmpty() {
        return this.itemList.isEmpty();
    }

    public void addItem(MetricItem item) {
        this.itemList.add(item);
    }

    public String toString() {
        StringBuilder snapshotBuilder = new StringBuilder(this.domain);
        boolean firstProperty = true;
        boolean firstItem = true;
        snapshotBuilder.append(':');
        MetricProperty[] metricPropertyArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            MetricProperty property = metricPropertyArray[n2];
            if (!firstProperty) {
                snapshotBuilder.append(',');
            }
            snapshotBuilder.append(property);
            firstProperty = false;
            ++n2;
        }
        snapshotBuilder.append('(');
        for (MetricItem item : this.itemList) {
            if (!firstItem) {
                snapshotBuilder.append(',');
            }
            snapshotBuilder.append(item);
            firstItem = false;
        }
        snapshotBuilder.append(')');
        return snapshotBuilder.toString();
    }
}

