/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationArguments;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.Metrics;
import org.smallmind.instrument.config.MetricConfiguration;

public abstract class ChronometerInstrument
extends Instrument<Chronometer> {
    public ChronometerInstrument(MetricConfiguration configuration, MetricProperty ... properties) {
        super(configuration == null || !configuration.isInstrumented() ? null : new InstrumentationArguments<Chronometer>(Metrics.buildChronometer(configuration.getSamples(), TimeUnit.MILLISECONDS, configuration.getTickInterval(), configuration.getTickTimeUnit()), configuration.getMetricDomain().getDomain(), properties));
    }

    public ChronometerInstrument(Metrics.MetricBuilder<Chronometer> builder, String domain, MetricProperty ... properties) {
        super(new InstrumentationArguments<Chronometer>(builder, domain, properties));
    }

    public abstract void withChronometer() throws Exception;

    @Override
    public final void with(Chronometer chronometer) throws Exception {
        long startTime = 0L;
        if (chronometer != null) {
            startTime = chronometer.getClock().getTimeNanoseconds();
        }
        this.withChronometer();
        if (chronometer != null) {
            chronometer.update(chronometer.getLatencyTimeUnit().convert(chronometer.getClock().getTimeNanoseconds() - startTime, TimeUnit.NANOSECONDS));
        }
    }
}

