/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.time.StintUtility;

public class ExponentiallyWeightedMovingAverage {
    private final AtomicReference<Double> average = new AtomicReference<Double>(0.0);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicLong unprocessed = new AtomicLong();
    private final double alpha;
    private final double intervalInNanos;

    public static ExponentiallyWeightedMovingAverage lastOneMinute(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 1);
    }

    public static ExponentiallyWeightedMovingAverage lastFiveMinutes(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 5);
    }

    public static ExponentiallyWeightedMovingAverage lastFifteenMinutes(long tickInterval, TimeUnit tickTimeUnit) {
        return new ExponentiallyWeightedMovingAverage(tickInterval, tickTimeUnit, 15);
    }

    private ExponentiallyWeightedMovingAverage(long tickInterval, TimeUnit tickTimeUnit, int minutes) {
        this.alpha = 1.0 - Math.exp(-((double)tickInterval / StintUtility.convertToDouble((long)minutes, (TimeUnit)TimeUnit.MINUTES, (TimeUnit)tickTimeUnit)));
        this.intervalInNanos = tickTimeUnit.toNanos(tickInterval);
    }

    public void clear() {
        this.initialized.set(false);
    }

    public void update(long n) {
        this.unprocessed.addAndGet(n);
    }

    public void tick() {
        if (this.initialized.compareAndSet(false, true)) {
            this.average.set((double)this.unprocessed.getAndSet(0L) / this.intervalInNanos);
        } else {
            double currentRate = this.average.get();
            this.average.set(currentRate + this.alpha * ((double)this.unprocessed.getAndSet(0L) / this.intervalInNanos - currentRate));
        }
    }

    public double getMovingAverage(TimeUnit rateTimeUnit) {
        return this.average.get() * (double)rateTimeUnit.toNanos(1L);
    }
}

