/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.license;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.smallmind.license.FileTypeFilenameFilter;
import org.smallmind.license.LicensedFileIterator;
import org.smallmind.license.Root;
import org.smallmind.license.Rule;
import org.smallmind.license.stencil.JavaDocStencil;
import org.smallmind.license.stencil.Stencil;

@Mojo(name="generate-notice-headers", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class SourceNoticeMojo
extends AbstractMojo {
    private static final Stencil[] DEFAULT_STENCILS = new Stencil[]{new JavaDocStencil()};
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter
    private Root root;
    @Parameter
    private Stencil[] stencils;
    @Parameter
    private Rule[] rules;
    @Parameter(defaultValue="false")
    private boolean allowNoticeRemoval;
    @Parameter(defaultValue="true")
    private boolean includeResources;
    @Parameter(defaultValue="false")
    private boolean includeTests;
    @Parameter(defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject rootProject = this.project;
        char[] buffer = new char[8192];
        while (this.root == null ? rootProject.getParent() != null : !this.root.getGroupId().equals(rootProject.getGroupId()) || !this.root.getArtifactId().equals(rootProject.getArtifactId())) {
            rootProject = rootProject.getParent();
        }
        Stencil[] mergedStencils = new Stencil[this.stencils != null ? this.stencils.length + DEFAULT_STENCILS.length : DEFAULT_STENCILS.length];
        System.arraycopy(DEFAULT_STENCILS, 0, mergedStencils, 0, DEFAULT_STENCILS.length);
        if (this.stencils != null) {
            System.arraycopy(this.stencils, 0, mergedStencils, DEFAULT_STENCILS.length, this.stencils.length);
        }
        for (Rule rule : this.rules) {
            String[] noticeArray;
            if (this.verbose) {
                this.getLog().info((CharSequence)String.format("Processing rule(%s)...", rule.getId()));
            }
            boolean noticed = true;
            if (rule.getNotice() == null) {
                if (!this.allowNoticeRemoval) {
                    throw new MojoExecutionException("No notice was provided for rule(" + rule.getId() + "), but notice removal has not been enabled(allowNoticeRemoval = false)");
                }
                noticeArray = null;
            } else {
                File noticeFile = new File(rule.getNotice());
                noticeArray = this.getFileAsLineArray(noticeFile.isAbsolute() ? noticeFile.getAbsolutePath() : rootProject.getBasedir() + System.getProperty("file.separator") + noticeFile.getPath());
                if (noticeArray == null) {
                    noticed = false;
                }
            }
            if (!noticed) {
                this.getLog().warn((CharSequence)String.format("Unable to acquire the notice file(%s), skipping notice updating...", rule.getNotice()));
                continue;
            }
            if (rule.getFileTypes() == null || rule.getFileTypes().length == 0) {
                throw new MojoExecutionException("No file types were specified for rule(" + rule.getId() + ")");
            }
            FileFilter[] fileFilters = new FileFilter[rule.getFileTypes().length];
            for (int count = 0; count < fileFilters.length; ++count) {
                fileFilters[count] = new FileTypeFilenameFilter(rule.getFileTypes()[count]);
            }
            boolean stenciled = false;
            for (Stencil stencil : mergedStencils) {
                if (!stencil.getId().equals(rule.getStencilId())) continue;
                stenciled = true;
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getSourceDirectory(), fileFilters);
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getScriptSourceDirectory(), fileFilters);
                if (this.includeResources) {
                    for (Resource resource : this.project.getBuild().getResources()) {
                        this.updateNotice(stencil, noticeArray, buffer, resource.getDirectory(), fileFilters);
                    }
                }
                if (!this.includeTests) break;
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getTestSourceDirectory(), fileFilters);
                if (!this.includeResources) break;
                for (Resource testResource : this.project.getBuild().getTestResources()) {
                    this.updateNotice(stencil, noticeArray, buffer, testResource.getDirectory(), fileFilters);
                }
                break;
            }
            if (stenciled) continue;
            throw new MojoExecutionException("No stencil found with id(" + rule.getStencilId() + ") for rule(" + rule.getId() + ")");
        }
    }

    private void updateNotice(Stencil stencil, String[] noticeArray, char[] buffer, String directoryPath, FileFilter ... fileFilters) throws MojoExecutionException {
        Pattern skipPattern = null;
        if (stencil.getSkipLines() != null) {
            skipPattern = Pattern.compile(stencil.getSkipLines());
        }
        for (File licensedFile : new LicensedFileIterator(new File(directoryPath), fileFilters)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)String.format((noticeArray == null ? "Removing" : "Updating") + " license notice for file(%s)...", licensedFile.getAbsolutePath()));
            }
            try {
                File tempFile = new File(licensedFile.getParent() + System.getProperty("file.separator") + "license.temp");
                FileWriter fileWriter = new FileWriter(tempFile);
                try {
                    int charsRead;
                    BufferedReader fileReader = new BufferedReader(new FileReader(licensedFile));
                    String unprocessedLine = this.seekNotice(stencil, skipPattern, fileReader, fileWriter);
                    if (noticeArray != null) {
                        this.applyNotice(stencil, noticeArray, fileWriter);
                    }
                    if (unprocessedLine != null) {
                        fileWriter.write(unprocessedLine);
                        fileWriter.write(System.getProperty("line.separator"));
                    }
                    while ((charsRead = fileReader.read(buffer)) >= 0) {
                        fileWriter.write(buffer, 0, charsRead);
                    }
                    fileWriter.close();
                    fileReader.close();
                    if (!licensedFile.delete()) {
                        throw new MojoFailureException("Unable to delete file(" + licensedFile.getAbsolutePath() + ")");
                    }
                }
                catch (Exception exception) {
                    tempFile.delete();
                    throw new MojoExecutionException("Exception during notice processing", exception);
                }
                if (tempFile.renameTo(licensedFile)) continue;
                throw new MojoFailureException("Unable to rename temp file(" + tempFile.getAbsolutePath() + ") to processed file(" + licensedFile.getAbsolutePath() + ")");
            }
            catch (MojoExecutionException mojoExecutionException) {
                throw mojoExecutionException;
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Exception during notice processing", exception);
            }
        }
    }

    private String[] getFileAsLineArray(String noticePath) throws MojoExecutionException {
        LinkedList<String> lineList;
        try {
            String singleLine;
            BufferedReader noticeReader = new BufferedReader(new FileReader(noticePath));
            lineList = new LinkedList<String>();
            while ((singleLine = noticeReader.readLine()) != null) {
                lineList.add(singleLine);
            }
        }
        catch (IOException ioException) {
            return null;
        }
        String[] lineArray = new String[lineList.size()];
        lineList.toArray(lineArray);
        return lineArray;
    }

    private String seekNotice(Stencil stencil, Pattern skipPattern, BufferedReader fileReader, FileWriter fileWriter) throws IOException, MojoFailureException {
        NoticeState noticeState;
        int whitespaceIndex;
        String singleLine = null;
        String generalPrefix = stencil.getBeforeEachLine() != null ? stencil.getBeforeEachLine() : "";
        for (whitespaceIndex = generalPrefix.length(); whitespaceIndex > 0 && Character.isWhitespace(generalPrefix.charAt(whitespaceIndex - 1)); --whitespaceIndex) {
        }
        generalPrefix = generalPrefix.substring(0, whitespaceIndex);
        NoticeState noticeState2 = noticeState = stencil.getFirstLine() != null ? NoticeState.FIRST : NoticeState.LAST;
        block5: while (!noticeState.equals((Object)NoticeState.COMPLETED) && !noticeState.equals((Object)NoticeState.TERMINATED) && (singleLine = fileReader.readLine()) != null) {
            if (skipPattern == null || !skipPattern.matcher(singleLine).matches()) {
                switch (noticeState) {
                    case FIRST: {
                        if (singleLine.length() <= 0) continue block5;
                        noticeState = singleLine.equals(stencil.getFirstLine()) ? NoticeState.LAST : NoticeState.TERMINATED;
                        continue block5;
                    }
                    case LAST: {
                        if (stencil.getLastLine() != null && singleLine.equals(stencil.getLastLine())) {
                            noticeState = NoticeState.COMPLETED;
                            continue block5;
                        }
                        if (singleLine.length() > 0 && !singleLine.startsWith(generalPrefix)) {
                            noticeState = NoticeState.TERMINATED;
                            continue block5;
                        }
                        if (singleLine.length() != 0 || !stencil.willPrefixBlankLines()) continue block5;
                        noticeState = NoticeState.TERMINATED;
                        continue block5;
                    }
                }
                throw new MojoFailureException("Unknown or inappropriate notice seeking state(" + noticeState.name() + ")");
            }
            fileWriter.write(singleLine);
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (noticeState.equals((Object)NoticeState.COMPLETED) || singleLine != null && singleLine.length() == 0) {
            while ((singleLine = fileReader.readLine()) != null && singleLine.length() == 0) {
            }
        }
        return singleLine;
    }

    private void applyNotice(Stencil stencil, String[] noticeArray, FileWriter fileWriter) throws IOException {
        for (int count = 0; count < stencil.getBlankLinesBefore(); ++count) {
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (stencil.getFirstLine() != null) {
            fileWriter.write(stencil.getFirstLine());
            fileWriter.write(System.getProperty("line.separator"));
        }
        for (String noticeLine : noticeArray) {
            if (stencil.getBeforeEachLine() != null && (noticeLine.length() > 0 || stencil.willPrefixBlankLines())) {
                fileWriter.write(stencil.getBeforeEachLine());
            }
            fileWriter.write(noticeLine);
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (stencil.getLastLine() != null) {
            fileWriter.write(stencil.getLastLine());
            fileWriter.write(System.getProperty("line.separator"));
        }
        for (int count = 0; count < stencil.getBlankLinesAfter(); ++count) {
            fileWriter.write(System.getProperty("line.separator"));
        }
    }

    private static enum NoticeState {
        FIRST,
        LAST,
        COMPLETED,
        TERMINATED;

    }
}

