/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.smallmind.license.Root;
import org.smallmind.license.Rule;

@Mojo(name="install-license-files", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class TargetLicenseMojo
extends AbstractMojo {
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter
    private Root root;
    @Parameter
    private Rule[] rules;
    @Parameter
    private String[] licenses;
    @Parameter(defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (new File(this.project.getBuild().getOutputDirectory()).exists()) {
            MavenProject rootProject = this.project;
            byte[] buffer = new byte[8192];
            while (this.root == null ? rootProject.getParent() != null : !this.root.getGroupId().equals(rootProject.getGroupId()) || !this.root.getArtifactId().equals(rootProject.getArtifactId())) {
                rootProject = rootProject.getParent();
            }
            for (String license : this.licenses) {
                FileOutputStream outputStream;
                File licenseFile = new File(license);
                if (!licenseFile.isAbsolute()) {
                    licenseFile = new File(rootProject.getBasedir() + System.getProperty("file.separator") + licenseFile.getPath());
                }
                if (!licenseFile.exists()) {
                    this.getLog().warn((CharSequence)String.format("Unable to acquire the license file(%s), skipping license copying...", licenseFile.getAbsolutePath()));
                    continue;
                }
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Copying license(%s)...", licenseFile.getName()));
                }
                File copyFile = new File(this.project.getBuild().getOutputDirectory() + System.getProperty("file.separator") + licenseFile.getName());
                try {
                    outputStream = new FileOutputStream(copyFile);
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException("Unable to create output license file (" + copyFile.getAbsolutePath() + ")", (Exception)ioException);
                }
                try {
                    int bytesRead;
                    FileInputStream inputStream = new FileInputStream(licenseFile);
                    while ((bytesRead = inputStream.read(buffer)) >= 0) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    inputStream.close();
                }
                catch (IOException ioException) {
                    copyFile.delete();
                    throw new MojoExecutionException("Problem in copying output license file (" + copyFile.getAbsolutePath() + ")", (Exception)ioException);
                }
                try {
                    outputStream.close();
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException("Problem in closing license file (" + licenseFile.getAbsolutePath() + ")", (Exception)ioException);
                }
            }
        }
    }
}

