/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.license;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.maven.plugin.MojoExecutionException;
import org.smallmind.license.CompoundFileFilter;

public class LicensedFileIterable
implements Iterable<File> {
    private final File directory;
    private final FileFilter[] fileFilters;

    public LicensedFileIterable(File directory, FileFilter[] fileFilters) throws MojoExecutionException {
        this.directory = directory;
        this.fileFilters = fileFilters;
        if (directory.exists() && !directory.isDirectory()) {
            throw new MojoExecutionException("Specified file(" + directory.getAbsolutePath() + ") isn't a directory");
        }
    }

    @Override
    public Iterator<File> iterator() {
        return new LicensedFileIterator(this.directory, this.fileFilters);
    }

    private class LicensedFileIterator
    implements Iterator<File> {
        private CompoundFileFilter compoundFileFilter;
        private LinkedList<File> directoryStack;
        private File currentFile;

        private LicensedFileIterator(File directory, FileFilter ... fileFilters) {
            this.compoundFileFilter = new CompoundFileFilter(fileFilters);
            this.directoryStack = new LinkedList();
            this.directoryStack.add(directory);
            this.currentFile = this.getNextFile();
        }

        private File getNextFile() {
            while (!this.directoryStack.isEmpty()) {
                File file = this.directoryStack.removeFirst();
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    LinkedList<File> appendedList = new LinkedList<File>();
                    for (File child : file.listFiles(this.compoundFileFilter)) {
                        if (child.isFile()) {
                            appendedList.addFirst(child);
                            continue;
                        }
                        appendedList.addLast(child);
                    }
                    if (appendedList.isEmpty()) continue;
                    this.directoryStack.addAll(0, appendedList);
                    continue;
                }
                return file;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.currentFile != null;
        }

        @Override
        public File next() {
            if (this.currentFile == null) {
                throw new NoSuchElementException();
            }
            File nextFile = this.currentFile;
            this.currentFile = this.getNextFile();
            return nextFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

