/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.license;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.smallmind.license.PathFilter;
import org.smallmind.license.PathTypeFilenameFilter;
import org.smallmind.license.Root;
import org.smallmind.license.Rule;
import org.smallmind.license.WrappedException;
import org.smallmind.license.stencil.JavaDocStencil;
import org.smallmind.license.stencil.Stencil;

@Mojo(name="generate-notice-headers", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class SourceNoticeMojo
extends AbstractMojo {
    private static final Stencil[] DEFAULT_STENCILS = new Stencil[]{new JavaDocStencil()};
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter
    private Root root;
    @Parameter
    private Stencil[] stencils;
    @Parameter
    private Rule[] rules;
    @Parameter(defaultValue="false")
    private boolean allowNoticeRemoval;
    @Parameter(defaultValue="true")
    private boolean includeResources;
    @Parameter(defaultValue="false")
    private boolean includeTests;
    @Parameter(defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject rootProject = this.project;
        char[] buffer = new char[8192];
        while (this.root == null ? rootProject.getParent() != null : !this.root.getGroupId().equals(rootProject.getGroupId()) || !this.root.getArtifactId().equals(rootProject.getArtifactId())) {
            rootProject = rootProject.getParent();
        }
        Stencil[] mergedStencils = new Stencil[this.stencils != null ? this.stencils.length + DEFAULT_STENCILS.length : DEFAULT_STENCILS.length];
        System.arraycopy(DEFAULT_STENCILS, 0, mergedStencils, 0, DEFAULT_STENCILS.length);
        if (this.stencils != null) {
            System.arraycopy(this.stencils, 0, mergedStencils, DEFAULT_STENCILS.length, this.stencils.length);
        }
        for (Rule rule : this.rules) {
            String[] noticeArray;
            if (this.verbose) {
                this.getLog().info((CharSequence)String.format("Processing rule(%s)...", rule.getId()));
            }
            boolean noticed = true;
            if (rule.getNotice() == null) {
                if (!this.allowNoticeRemoval) {
                    throw new MojoExecutionException("No notice was provided for rule(" + rule.getId() + "), but notice removal has not been enabled(allowNoticeRemoval = false)");
                }
                noticeArray = null;
            } else {
                Path noticeFile = Paths.get(rule.getNotice(), new String[0]);
                noticeArray = this.getFileAsLineArray(noticeFile.isAbsolute() ? noticeFile : rootProject.getBasedir().toPath().resolve(noticeFile));
                if (noticeArray == null) {
                    noticed = false;
                }
            }
            if (!noticed) {
                this.getLog().warn((CharSequence)String.format("Unable to acquire the notice file(%s), skipping notice updating...", rule.getNotice()));
                continue;
            }
            if (rule.getFileTypes() == null || rule.getFileTypes().length == 0) {
                throw new MojoExecutionException("No file types were specified for rule(" + rule.getId() + ")");
            }
            PathFilter[] pathFilters = new PathFilter[rule.getFileTypes().length];
            for (int count = 0; count < pathFilters.length; ++count) {
                pathFilters[count] = new PathTypeFilenameFilter(rule.getFileTypes()[count]);
            }
            boolean stenciled = false;
            for (Stencil stencil : mergedStencils) {
                if (!stencil.getId().equals(rule.getStencilId())) continue;
                stenciled = true;
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getSourceDirectory(), pathFilters);
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getScriptSourceDirectory(), pathFilters);
                if (this.includeResources) {
                    for (Resource resource : this.project.getBuild().getResources()) {
                        this.updateNotice(stencil, noticeArray, buffer, resource.getDirectory(), pathFilters);
                    }
                }
                if (!this.includeTests) break;
                this.updateNotice(stencil, noticeArray, buffer, this.project.getBuild().getTestSourceDirectory(), pathFilters);
                if (!this.includeResources) break;
                for (Resource testResource : this.project.getBuild().getTestResources()) {
                    this.updateNotice(stencil, noticeArray, buffer, testResource.getDirectory(), pathFilters);
                }
                break;
            }
            if (stenciled) continue;
            throw new MojoExecutionException("No stencil found with id(" + rule.getStencilId() + ") for rule(" + rule.getId() + ")");
        }
    }

    private void updateNotice(Stencil stencil, String[] noticeArray, char[] buffer, String directory, PathFilter ... pathFilters) throws MojoFailureException {
        Path directoryPath = Paths.get(directory, new String[0]);
        if (Files.isDirectory(directoryPath, new LinkOption[0])) {
            Pattern skipPattern = stencil.getSkipLines() != null ? Pattern.compile(stencil.getSkipLines()) : null;
            try (Stream<Path> pathStream = Files.walk(directoryPath, new FileVisitOption[0]);){
                try {
                    pathStream.forEach(licensedPath -> {
                        if (Files.isRegularFile(licensedPath, new LinkOption[0]) && this.accept((Path)licensedPath, pathFilters)) {
                            if (this.verbose) {
                                this.getLog().info((CharSequence)String.format((noticeArray == null ? "Removing" : "Updating") + " license notice for file(%s)...", licensedPath));
                            }
                            try {
                                Path tempPath = licensedPath.getParent().resolve("license.temp");
                                try (BufferedWriter fileWriter = Files.newBufferedWriter(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                                     BufferedReader fileReader = Files.newBufferedReader(licensedPath);){
                                    int charsRead;
                                    String unprocessedLine = this.seekNotice(stencil, skipPattern, fileReader, fileWriter);
                                    if (noticeArray != null) {
                                        this.applyNotice(stencil, noticeArray, fileWriter);
                                    }
                                    if (unprocessedLine != null) {
                                        fileWriter.write(unprocessedLine);
                                        fileWriter.write(System.getProperty("line.separator"));
                                    }
                                    while ((charsRead = fileReader.read(buffer)) >= 0) {
                                        fileWriter.write(buffer, 0, charsRead);
                                    }
                                }
                                Files.move(tempPath, licensedPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException ioException) {
                                throw new WrappedException((Exception)((Object)new MojoFailureException(ioException.getMessage(), (Throwable)ioException)));
                            }
                            catch (MojoFailureException mojoFailureException) {
                                throw new WrappedException((Exception)((Object)mojoFailureException));
                            }
                        }
                    });
                }
                catch (WrappedException wrappingException) {
                    throw wrappingException.convert(MojoFailureException.class);
                }
            }
            catch (IOException ioException) {
                throw new MojoFailureException(ioException.getMessage(), (Throwable)ioException);
            }
        }
    }

    private boolean accept(Path path, PathFilter ... pathFilters) {
        if (pathFilters != null && pathFilters.length > 0) {
            for (PathFilter pathFilter : pathFilters) {
                if (!pathFilter.accept(path)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String[] getFileAsLineArray(Path noticePath) {
        LinkedList<String> lineList;
        try (BufferedReader noticeReader = Files.newBufferedReader(noticePath);){
            String singleLine;
            lineList = new LinkedList<String>();
            while ((singleLine = noticeReader.readLine()) != null) {
                lineList.add(singleLine);
            }
        }
        catch (IOException ioException) {
            return null;
        }
        String[] lineArray = new String[lineList.size()];
        lineList.toArray(lineArray);
        return lineArray;
    }

    private String seekNotice(Stencil stencil, Pattern skipPattern, BufferedReader fileReader, BufferedWriter fileWriter) throws IOException, MojoFailureException {
        NoticeState noticeState;
        int whitespaceIndex;
        String singleLine = null;
        String generalPrefix = stencil.getBeforeEachLine() != null ? stencil.getBeforeEachLine() : "";
        for (whitespaceIndex = generalPrefix.length(); whitespaceIndex > 0 && Character.isWhitespace(generalPrefix.charAt(whitespaceIndex - 1)); --whitespaceIndex) {
        }
        generalPrefix = generalPrefix.substring(0, whitespaceIndex);
        NoticeState noticeState2 = noticeState = stencil.getFirstLine() != null ? NoticeState.FIRST : NoticeState.LAST;
        block5: while (!noticeState.equals((Object)NoticeState.COMPLETED) && !noticeState.equals((Object)NoticeState.TERMINATED) && (singleLine = fileReader.readLine()) != null) {
            if (skipPattern == null || !skipPattern.matcher(singleLine).matches()) {
                switch (noticeState) {
                    case FIRST: {
                        if (singleLine.length() <= 0) continue block5;
                        noticeState = singleLine.equals(stencil.getFirstLine()) ? NoticeState.LAST : NoticeState.TERMINATED;
                        continue block5;
                    }
                    case LAST: {
                        if (stencil.getLastLine() != null && singleLine.equals(stencil.getLastLine())) {
                            noticeState = NoticeState.COMPLETED;
                            continue block5;
                        }
                        if (singleLine.length() > 0 && !singleLine.startsWith(generalPrefix)) {
                            noticeState = NoticeState.TERMINATED;
                            continue block5;
                        }
                        if (singleLine.length() != 0 || !stencil.willPrefixBlankLines()) continue block5;
                        noticeState = NoticeState.TERMINATED;
                        continue block5;
                    }
                }
                throw new MojoFailureException("Unknown or inappropriate notice seeking state(" + noticeState.name() + ")");
            }
            fileWriter.write(singleLine);
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (noticeState.equals((Object)NoticeState.COMPLETED) || singleLine != null && singleLine.length() == 0) {
            while ((singleLine = fileReader.readLine()) != null && singleLine.length() == 0) {
            }
        }
        return singleLine;
    }

    private void applyNotice(Stencil stencil, String[] noticeArray, BufferedWriter fileWriter) throws IOException {
        for (int count = 0; count < stencil.getBlankLinesBefore(); ++count) {
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (stencil.getFirstLine() != null) {
            fileWriter.write(stencil.getFirstLine());
            fileWriter.write(System.getProperty("line.separator"));
        }
        for (String noticeLine : noticeArray) {
            if (stencil.getBeforeEachLine() != null && (noticeLine.length() > 0 || stencil.willPrefixBlankLines())) {
                fileWriter.write(stencil.getBeforeEachLine());
            }
            fileWriter.write(noticeLine);
            fileWriter.write(System.getProperty("line.separator"));
        }
        if (stencil.getLastLine() != null) {
            fileWriter.write(stencil.getLastLine());
            fileWriter.write(System.getProperty("line.separator"));
        }
        for (int count = 0; count < stencil.getBlankLinesAfter(); ++count) {
            fileWriter.write(System.getProperty("line.separator"));
        }
    }

    private static enum NoticeState {
        FIRST,
        LAST,
        COMPLETED,
        TERMINATED;

    }
}

