/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.license;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.smallmind.license.Root;
import org.smallmind.license.Rule;

@Mojo(name="install-license-files", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class TargetLicenseMojo
extends AbstractMojo {
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter
    private Root root;
    @Parameter
    private Rule[] rules;
    @Parameter
    private String[] licenses;
    @Parameter(defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException {
        if (Files.isDirectory(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), new LinkOption[0])) {
            MavenProject rootProject = this.project;
            while (this.root == null ? rootProject.getParent() != null : !this.root.getGroupId().equals(rootProject.getGroupId()) || !this.root.getArtifactId().equals(rootProject.getArtifactId())) {
                rootProject = rootProject.getParent();
            }
            for (String license : this.licenses) {
                Path licenseFile = Paths.get(license, new String[0]);
                if (!licenseFile.isAbsolute()) {
                    licenseFile = rootProject.getBasedir().toPath().resolve(license);
                }
                if (!Files.isRegularFile(licenseFile, new LinkOption[0])) {
                    this.getLog().warn((CharSequence)String.format("Unable to acquire the license file(%s), skipping license copying...", licenseFile));
                    continue;
                }
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Copying license(%s)...", licenseFile.getFileName()));
                }
                Path copyFile = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]).resolve(licenseFile.getFileName());
                try {
                    Files.copy(licenseFile, copyFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ioException) {
                    try {
                        Files.deleteIfExists(copyFile);
                        throw new MojoExecutionException("Problem in copying output license file (" + copyFile + ")", (Exception)ioException);
                    }
                    catch (IOException innerIoException) {
                        throw new MojoExecutionException("Problem in copying output license file (" + copyFile + ")", innerIoException.initCause(ioException));
                    }
                }
            }
        }
    }
}

