/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.TransmissionCallback;
import org.smallmind.phalanx.wire.TransportTimeoutException;
import org.smallmind.phalanx.wire.TypeUtility;
import org.smallmind.web.jersey.fault.Fault;
import org.smallmind.web.jersey.fault.FaultWrappingException;
import org.smallmind.web.jersey.fault.NativeLanguage;
import org.smallmind.web.jersey.fault.NativeObject;

public class AsynchronousTransmissionCallback
implements TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<Duration> timeoutDurationRef = new AtomicReference();
    private final AtomicReference<ResultSignal> resultSignalRef = new AtomicReference();
    private String serviceName;
    private String functionName;

    public AsynchronousTransmissionCallback(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public void destroy(Duration timeoutDuration) {
        this.timeoutDurationRef.set(timeoutDuration);
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult(SignalCodec signalCodec) throws Throwable {
        this.resultLatch.await();
        ResultSignal resultSignal = this.resultSignalRef.get();
        if (resultSignal == null) {
            Duration timeoutDuration = this.timeoutDurationRef.get();
            throw new TransportTimeoutException("The timeout(%s) milliseconds was exceeded while waiting for a response(%s.%s)", timeoutDuration == null ? "unknown" : String.valueOf(timeoutDuration.toMilliseconds()), this.serviceName, this.functionName);
        }
        if (resultSignal.isError()) {
            Fault fault = signalCodec.extractObject(resultSignal.getResult(), Fault.class);
            NativeObject nativeObject = fault.getNativeObject();
            if (nativeObject != null && nativeObject.getLanguage().equals((Object)NativeLanguage.JAVA)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nativeObject.getBytes());
                Throwable throwable = null;
                try {
                    try {
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Throwable throwable2 = null;
                        try {
                            try {
                                throw (Throwable)objectInputStream.readObject();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (objectInputStream != null) {
                                if (throwable2 != null) {
                                    try {
                                        objectInputStream.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                } else {
                                    objectInputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    if (byteArrayInputStream != null) {
                        if (throwable != null) {
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            byteArrayInputStream.close();
                        }
                    }
                    throw throwable6;
                }
            }
            throw new FaultWrappingException(fault);
        }
        return signalCodec.extractObject(resultSignal.getResult(), TypeUtility.nativeDecode(resultSignal.getNativeType()));
    }

    public void setResultSignal(ResultSignal resultSignal) {
        this.resultSignalRef.set(resultSignal);
        this.resultLatch.countDown();
    }
}

