/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.mock;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.nutsnbolts.util.SelfDestructive;
import org.smallmind.nutsnbolts.util.SelfDestructiveMap;
import org.smallmind.phalanx.wire.Address;
import org.smallmind.phalanx.wire.AsynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.RequestTransport;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.SynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.TransmissionCallback;
import org.smallmind.phalanx.wire.WireContext;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.mock.MockMessage;
import org.smallmind.phalanx.wire.mock.MockMessageListener;
import org.smallmind.phalanx.wire.mock.MockMessageProperties;
import org.smallmind.phalanx.wire.mock.MockMessageRouter;
import org.smallmind.scribe.pen.LoggerManager;

public class MockRequestTransport
implements RequestTransport {
    private final MockMessageRouter messageRouter;
    private final SignalCodec signalCodec;
    private final SelfDestructiveMap<String, TransmissionCallback> callbackMap;
    private final String callerId = UUID.randomUUID().toString();

    public MockRequestTransport(MockMessageRouter messageRouter, final SignalCodec signalCodec, int timeoutSeconds) {
        this.messageRouter = messageRouter;
        this.signalCodec = signalCodec;
        this.callbackMap = new SelfDestructiveMap(new Duration((long)timeoutSeconds, TimeUnit.SECONDS));
        messageRouter.getResponseTopic().addListener(new MockMessageListener(){

            @Override
            public boolean match(MockMessageProperties properties) {
                return properties.getHeader(WireProperty.CALLER_ID.getKey()).equals(MockRequestTransport.this.callerId);
            }

            @Override
            public void handle(MockMessage message) {
                try {
                    MockRequestTransport.this.completeCallback(new String(message.getProperties().getCorrelationId()), signalCodec.decode(message.getBytes(), 0, message.getBytes().length, ResultSignal.class));
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(MockRequestTransport.class).error((Throwable)exception);
                }
            }
        });
    }

    @Override
    public String getCallerId() {
        return this.callerId;
    }

    @Override
    public void transmitInOnly(String serviceGroup, String instanceId, Address address, Map<String, Object> arguments, WireContext ... contexts) throws Exception {
        this.transmit(true, serviceGroup, instanceId, address, arguments, contexts);
    }

    @Override
    public Object transmitInOut(String serviceGroup, String instanceId, Address address, Map<String, Object> arguments, WireContext ... contexts) throws Throwable {
        return this.transmit(false, serviceGroup, instanceId, address, arguments, contexts).getResult(this.signalCodec);
    }

    private TransmissionCallback transmit(boolean inOnly, String serviceGroup, String instanceId, Address address, Map<String, Object> arguments, WireContext ... contexts) throws Exception {
        MockMessage message = new MockMessage(this.signalCodec.encode(new InvocationSignal(inOnly, address, arguments, contexts)));
        String messageId = UUID.randomUUID().toString();
        if (!inOnly) {
            message.getProperties().setHeader(WireProperty.CALLER_ID.getKey(), this.callerId);
        }
        message.getProperties().setMessageId(messageId);
        message.getProperties().setTimestamp(new Date());
        message.getProperties().setContentType(this.signalCodec.getContentType());
        message.getProperties().setHeader(WireProperty.CLOCK.getKey(), System.currentTimeMillis());
        message.getProperties().setHeader(WireProperty.SERVICE_GROUP.getKey(), serviceGroup);
        if (instanceId != null) {
            message.getProperties().setHeader(WireProperty.INSTANCE_ID.getKey(), instanceId);
            this.messageRouter.getWhisperRequestTopic().send(message);
        } else {
            this.messageRouter.getTalkRequestQueue().send(message);
        }
        if (!inOnly) {
            AsynchronousTransmissionCallback asynchronousCallback = new AsynchronousTransmissionCallback(address.getService(), address.getFunction().getName());
            SynchronousTransmissionCallback previousCallback = (SynchronousTransmissionCallback)this.callbackMap.putIfAbsent((Comparable)((Object)messageId), (SelfDestructive)asynchronousCallback);
            if (previousCallback != null) {
                return previousCallback;
            }
            return asynchronousCallback;
        }
        return null;
    }

    public void completeCallback(String correlationId, ResultSignal resultSignal) {
        TransmissionCallback previousCallback = (TransmissionCallback)this.callbackMap.get((Comparable)((Object)correlationId));
        if (previousCallback == null) {
            previousCallback = (TransmissionCallback)this.callbackMap.putIfAbsent((Comparable)((Object)correlationId), (SelfDestructive)new SynchronousTransmissionCallback(resultSignal));
            if (previousCallback != null && previousCallback instanceof AsynchronousTransmissionCallback) {
                ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
            }
        } else if (previousCallback instanceof AsynchronousTransmissionCallback) {
            ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

