/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.jms;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.phalanx.wire.MetricType;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.jms.ConnectionManager;
import org.smallmind.phalanx.wire.jms.JmsResponseTransport;
import org.smallmind.phalanx.wire.jms.QueueOperator;
import org.smallmind.phalanx.wire.jms.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class RequestListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JmsResponseTransport jmsResponseTransport;
    private final ConnectionManager requestConnectionManager;
    private final Destination requestDestination;
    private final String selector;

    public RequestListener(JmsResponseTransport jmsResponseTransport, ConnectionManager requestConnectionManager, Destination requestDestination, String serviceGroup, String instanceId) throws JMSException {
        this.jmsResponseTransport = jmsResponseTransport;
        this.requestConnectionManager = requestConnectionManager;
        this.requestDestination = requestDestination;
        this.selector = instanceId == null ? WireProperty.SERVICE_GROUP.getKey() + "='" + serviceGroup + "'" : WireProperty.SERVICE_GROUP.getKey() + "='" + serviceGroup + "' AND " + WireProperty.INSTANCE_ID.getKey() + "='" + instanceId + "'";
        requestConnectionManager.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.requestDestination;
    }

    @Override
    public String getMessageSelector() {
        return this.selector;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.requestConnectionManager.stop();
            this.requestConnectionManager.close();
        }
    }

    public void onMessage(Message message) {
        try {
            long timeInQueue = System.currentTimeMillis() - message.getLongProperty(WireProperty.CLOCK.getKey());
            LoggerManager.getLogger(QueueOperator.class).debug("request message received(%s) in %d ms...", new Object[]{message.getJMSMessageID(), timeInQueue});
            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)this.jmsResponseTransport, (long)(timeInQueue >= 0L ? timeInQueue : 0L), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("queue", MetricType.REQUEST_DESTINATION_TRANSIT.getDisplay())});
            this.jmsResponseTransport.execute(message);
        }
        catch (Exception exception) {
            LoggerManager.getLogger(RequestListener.class).error((Throwable)exception);
        }
    }
}

