/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.amqp.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.smallmind.phalanx.wire.amqp.rabbitmq.NameConfiguration;
import org.smallmind.phalanx.wire.amqp.rabbitmq.RabbitMQConnector;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class MessageRouter {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicStampedReference<Channel> channelRef = new AtomicStampedReference<Object>(null, 0);
    private final AtomicInteger version = new AtomicInteger(0);
    private final RabbitMQConnector connector;
    private final NameConfiguration nameConfiguration;

    public MessageRouter(RabbitMQConnector connector, NameConfiguration nameConfiguration) {
        this.connector = connector;
        this.nameConfiguration = nameConfiguration;
    }

    public abstract void bindQueues(Channel var1) throws IOException;

    public abstract void installConsumer(Channel var1) throws IOException;

    public void initialize() throws IOException {
        this.ensureChannel(0);
    }

    public String getRequestExchangeName() {
        return this.nameConfiguration.getRequestExchange();
    }

    public String getResponseExchangeName() {
        return this.nameConfiguration.getResponseExchange();
    }

    public String getResponseQueueName() {
        return this.nameConfiguration.getResponseQueue();
    }

    public String getShoutQueueName() {
        return this.nameConfiguration.getShoutQueue();
    }

    public String getTalkQueueName() {
        return this.nameConfiguration.getTalkQueue();
    }

    public String getWhisperQueueName() {
        return this.nameConfiguration.getWhisperQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureChannel(int stamp) throws IOException {
        AtomicStampedReference<Channel> atomicStampedReference = this.channelRef;
        synchronized (atomicStampedReference) {
            if (this.channelRef.getStamp() == stamp) {
                Channel channel = this.connector.getConnection().createChannel();
                channel.basicQos(0, 1, false);
                channel.exchangeDeclare(this.getRequestExchangeName(), "direct", false, false, null);
                channel.exchangeDeclare(this.getResponseExchangeName(), "direct", false, false, null);
                this.bindQueues(channel);
                final int nextStamp = this.version.incrementAndGet();
                this.channelRef.set(channel, nextStamp);
                channel.addShutdownListener(new ShutdownListener(){

                    public void shutdownCompleted(ShutdownSignalException cause) {
                        try {
                            if (!MessageRouter.this.closed.get()) {
                                MessageRouter.this.ensureChannel(nextStamp);
                            }
                        }
                        catch (IOException ioException) {
                            LoggerManager.getLogger(RabbitMQConnector.class).error((Throwable)ioException);
                        }
                    }
                });
                this.installConsumer(channel);
            }
        }
    }

    public void send(String routingKey, String exchangeName, AMQP.BasicProperties properties, byte[] body) throws IOException {
        boolean sent = false;
        do {
            int[] stampHolder = new int[1];
            Channel channel = this.channelRef.get(stampHolder);
            try {
                channel.basicPublish(exchangeName, routingKey, true, false, properties, body);
                sent = true;
            }
            catch (AlreadyClosedException exception) {
                this.ensureChannel(stampHolder[0]);
            }
        } while (!sent);
    }

    public long getTimestamp(AMQP.BasicProperties properties) {
        Date date = properties.getTimestamp();
        if (date != null) {
            return date.getTime();
        }
        return Long.MAX_VALUE;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channelRef.getReference().close();
        }
    }
}

