/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.TransmissionCallback;
import org.smallmind.phalanx.wire.TransportTimeoutException;
import org.smallmind.phalanx.wire.TypeUtility;

public class AsynchronousTransmissionCallback
extends TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<Duration> timeoutDurationRef = new AtomicReference();
    private final AtomicReference<ResultSignal> resultSignalRef = new AtomicReference();
    private String serviceName;
    private String functionName;

    public AsynchronousTransmissionCallback(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public void destroy(Duration timeoutDuration) {
        this.timeoutDurationRef.set(timeoutDuration);
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult(SignalCodec signalCodec) throws Throwable {
        this.resultLatch.await();
        ResultSignal resultSignal = this.resultSignalRef.get();
        if (resultSignal == null) {
            Duration timeoutDuration = this.timeoutDurationRef.get();
            throw new TransportTimeoutException("The timeout(%s) milliseconds was exceeded while waiting for a response(%s.%s)", timeoutDuration == null ? "unknown" : String.valueOf(timeoutDuration.toMilliseconds()), this.serviceName, this.functionName);
        }
        this.handleError(signalCodec, resultSignal);
        return signalCodec.extractObject(resultSignal.getResult(), TypeUtility.nativeDecode(resultSignal.getNativeType()));
    }

    public void setResultSignal(ResultSignal resultSignal) {
        this.resultSignalRef.set(resultSignal);
        this.resultLatch.countDown();
    }
}

