/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.smallmind.phalanx.wire.ProtoWireContext;
import org.smallmind.phalanx.wire.WireContext;
import org.smallmind.phalanx.wire.WireContextManager;
import org.smallmind.web.jersey.util.JsonCodec;

public class WireContextXmlAdapter
extends XmlAdapter<Object[], WireContext[]> {
    public WireContext[] unmarshal(Object[] objects) {
        LinkedList<Object> contextList = new LinkedList<Object>();
        if (objects != null) {
            for (Object obj : objects) {
                LinkedHashMap objectMap = (LinkedHashMap)obj;
                if (objectMap.size() != 1) continue;
                Map.Entry topEntry = objectMap.entrySet().iterator().next();
                Class<? extends WireContext> contextClass = WireContextManager.getContextClass((String)topEntry.getKey());
                if (contextClass != null) {
                    contextList.add(JsonCodec.convert(topEntry.getValue(), contextClass));
                    continue;
                }
                contextList.add(new ProtoWireContext((String)topEntry.getKey(), topEntry.getValue()));
            }
        }
        WireContext[] contexts = new WireContext[contextList.size()];
        contextList.toArray(contexts);
        return contexts;
    }

    public Object[] marshal(WireContext[] wireContexts) {
        if (wireContexts == null) {
            return null;
        }
        Object[] objects = new Object[wireContexts.length];
        int index = 0;
        for (WireContext wireContext : wireContexts) {
            LinkedHashMap<String, Object> objectMap;
            if (wireContext instanceof ProtoWireContext) {
                objectMap = new LinkedHashMap<String, Object>();
                objectMap.put(((ProtoWireContext)wireContext).getSkin(), ((ProtoWireContext)wireContext).getGuts());
                objects[index++] = objectMap;
                continue;
            }
            objectMap = new LinkedHashMap();
            XmlRootElement xmlRootElementAnnotation = wireContext.getClass().getAnnotation(XmlRootElement.class);
            objectMap.put(xmlRootElementAnnotation == null ? wireContext.getClass().getSimpleName() : xmlRootElementAnnotation.name(), wireContext);
            objects[index++] = objectMap;
        }
        return objects;
    }
}

