/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.jms;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import org.smallmind.phalanx.wire.jms.ConnectionManager;
import org.smallmind.phalanx.wire.jms.MessageHandler;
import org.smallmind.phalanx.wire.jms.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class TopicOperator
implements SessionEmployer,
MessageHandler {
    private final ConnectionManager connectionManager;
    private final Topic topic;

    public TopicOperator(ConnectionManager connectionManager, Topic topic) {
        this.connectionManager = connectionManager;
        this.topic = topic;
    }

    @Override
    public Destination getDestination() {
        return this.topic;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    @Override
    public BytesMessage createMessage() throws JMSException {
        return this.connectionManager.getSession(this).createBytesMessage();
    }

    @Override
    public void send(Message message) throws JMSException {
        this.connectionManager.getProducer(this).send(message);
        LoggerManager.getLogger(TopicOperator.class).debug("topic message sent(%s)...", new Object[]{message.getJMSMessageID()});
    }
}

