/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.worker;

import java.lang.reflect.Array;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.phalanx.worker.MetricInteraction;
import org.smallmind.phalanx.worker.WorkManagerException;
import org.smallmind.phalanx.worker.Worker;
import org.smallmind.phalanx.worker.WorkerFactory;
import org.smallmind.scribe.pen.LoggerManager;

public class WorkManager<W extends Worker<T>, T>
implements MetricConfigurationProvider {
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.STOPPED);
    private final MetricConfiguration metricConfiguration;
    private final TransferQueue<T> transferQueue;
    private final Class<W> workerClass;
    private final int concurrencyLimit;
    private W[] workers;

    public WorkManager(MetricConfiguration metricConfiguration, Class<W> workerClass, int concurrencyLimit) {
        this.metricConfiguration = metricConfiguration;
        this.workerClass = workerClass;
        this.concurrencyLimit = concurrencyLimit;
        this.transferQueue = new LinkedTransferQueue<T>();
    }

    public int getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    public MetricConfiguration getMetricConfiguration() {
        return this.metricConfiguration;
    }

    public void startUp(WorkerFactory<W, T> workerFactory) throws InterruptedException {
        if (this.stateRef.compareAndSet(State.STOPPED, State.STARTING)) {
            this.workers = (Worker[])Array.newInstance(this.workerClass, this.concurrencyLimit);
            for (int index = 0; index < this.workers.length; ++index) {
                this.workers[index] = workerFactory.createWorker(this.metricConfiguration, this.transferQueue);
                Thread workerThread = new Thread((Runnable)this.workers[index]);
                workerThread.setDaemon(true);
                workerThread.start();
            }
            this.stateRef.set(State.STARTED);
        } else {
            while (State.STARTING.equals((Object)this.stateRef.get())) {
                Thread.sleep(100L);
            }
        }
    }

    public void execute(final T work) throws Exception {
        if (!State.STARTED.equals((Object)this.stateRef.get())) {
            throw new WorkManagerException("%s is not in the 'started' state", WorkManager.class.getSimpleName());
        }
        InstrumentationManager.execute((Instrument)new ChronometerInstrument(this, new MetricProperty[]{new MetricProperty("event", MetricInteraction.ACQUIRE_WORKER.getDisplay())}){

            public void withChronometer() throws InterruptedException {
                boolean success;
                while (!(success = WorkManager.this.transferQueue.tryTransfer(work, 1L, TimeUnit.SECONDS))) {
                }
            }
        });
    }

    public void shutDown() throws InterruptedException {
        if (this.stateRef.compareAndSet(State.STARTED, State.STOPPING)) {
            for (W worker : this.workers) {
                try {
                    ((Worker)worker).stop();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(WorkManager.class).error((Throwable)exception);
                }
            }
            this.stateRef.set(State.STOPPED);
        } else {
            while (State.STOPPING.equals((Object)this.stateRef.get())) {
                Thread.sleep(100L);
            }
        }
    }

    private static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

