/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.util.concurrent.TimeUnit;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.nutsnbolts.util.SelfDestructive;
import org.smallmind.nutsnbolts.util.SelfDestructiveMap;
import org.smallmind.phalanx.wire.AsynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.RequestTransport;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.TransmissionCallback;

public abstract class AbstractRequestTransport
implements RequestTransport {
    private final SelfDestructiveMap<String, TransmissionCallback> callbackMap;

    public AbstractRequestTransport(int defaultTimeoutSeconds) {
        this.callbackMap = new SelfDestructiveMap(new Duration((long)defaultTimeoutSeconds, TimeUnit.SECONDS));
    }

    public SelfDestructiveMap<String, TransmissionCallback> getCallbackMap() {
        return this.callbackMap;
    }

    @Override
    public void completeCallback(String correlationId, ResultSignal resultSignal) {
        TransmissionCallback previousCallback = (TransmissionCallback)this.callbackMap.get((Comparable)((Object)correlationId));
        if (previousCallback == null) {
            previousCallback = (TransmissionCallback)this.callbackMap.putIfAbsent((Comparable)((Object)correlationId), (SelfDestructive)new SynchronousTransmissionCallback(resultSignal));
            if (previousCallback != null && previousCallback instanceof AsynchronousTransmissionCallback) {
                ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
            }
        } else if (previousCallback instanceof AsynchronousTransmissionCallback) {
            ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
        }
    }
}

