/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.amqp.rabbitmq.spring;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import java.util.ArrayList;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessor;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessorManager;
import org.smallmind.phalanx.wire.amqp.rabbitmq.RabbitMQConnector;
import org.smallmind.phalanx.wire.amqp.rabbitmq.spring.RabbitMQServer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RabbitMQConnectorFactory
implements FactoryBean<RabbitMQConnector>,
InitializingBean {
    private RabbitMQConnector rabbitMQConnector;
    private String username;
    private String password;
    private int heartbeatSeconds;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHeartbeatSeconds(int heartbeatSeconds) {
        this.heartbeatSeconds = heartbeatSeconds;
    }

    public Class<?> getObjectType() {
        return RabbitMQConnector.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public RabbitMQConnector getObject() {
        return this.rabbitMQConnector;
    }

    public void afterPropertiesSet() {
        SpringPropertyAccessor springPropertyAccessor = SpringPropertyAccessorManager.getSpringPropertyAccessor();
        ArrayList<RabbitMQServer> serverList = new ArrayList<RabbitMQServer>();
        int addressIndex = 0;
        for (String key : springPropertyAccessor.getKeySet()) {
            int index;
            if (key.startsWith("rabbitmq.host.")) {
                index = Integer.valueOf(key.substring("rabbitmq.host.".length()));
                while (serverList.size() < index + 1) {
                    serverList.add(new RabbitMQServer());
                }
                ((RabbitMQServer)serverList.get(index)).setHost(springPropertyAccessor.asString(key));
                continue;
            }
            if (!key.startsWith("rabbitmq.port.")) continue;
            index = Integer.valueOf(key.substring("rabbitmq.host.".length()));
            while (serverList.size() < index + 1) {
                serverList.add(new RabbitMQServer());
            }
            ((RabbitMQServer)serverList.get(index)).setPort((Integer)springPropertyAccessor.asInt(key).get());
        }
        Address[] addresses = new Address[serverList.size()];
        for (RabbitMQServer server : serverList) {
            addresses[addressIndex++] = new Address(server.getHost(), server.getPort());
        }
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setRequestedHeartbeat(this.heartbeatSeconds);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        this.rabbitMQConnector = new RabbitMQConnector(connectionFactory, addresses);
    }
}

