/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.jms.hornetq.spring;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.smallmind.nutsnbolts.spring.RuntimeBeansException;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessor;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessorManager;
import org.smallmind.nutsnbolts.util.Option;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DynamicHornetQTransportConfigurationListFactoryBean
implements InitializingBean,
FactoryBean<List<TransportConfiguration>> {
    private final HashMap<String, TransportConfiguration> transportConfigurationMap = new HashMap();

    public void afterPropertiesSet() {
        SpringPropertyAccessor springPropertyAccessor = SpringPropertyAccessorManager.getSpringPropertyAccessor();
        for (String key : springPropertyAccessor.getKeySet()) {
            String transportName;
            if (!key.startsWith("jms.hornetq.transport.host.") || (transportName = key.substring("jms.hornetq.transport.host.".length())).contains(".")) continue;
            Option transportPortOption = springPropertyAccessor.asInt("jms.hornetq.transport.port." + transportName);
            if (transportPortOption.isNone()) {
                throw new RuntimeBeansException("Missing port definition for transport configuration(%s)", new Object[]{transportName});
            }
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            propertyMap.put("host", springPropertyAccessor.asString("jms.hornetq.transport.host." + transportName));
            propertyMap.put("port", ((Integer)transportPortOption.get()).toString());
            this.transportConfigurationMap.put(transportName, new TransportConfiguration(NettyConnectorFactory.class.getName(), propertyMap));
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return List.class;
    }

    public List<TransportConfiguration> getObject() throws Exception {
        return new LinkedList<TransportConfiguration>(this.transportConfigurationMap.values());
    }
}

