/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.mock;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.smallmind.phalanx.wire.AbstractRequestTransport;
import org.smallmind.phalanx.wire.Address;
import org.smallmind.phalanx.wire.ConversationType;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.VocalMode;
import org.smallmind.phalanx.wire.Voice;
import org.smallmind.phalanx.wire.WireContext;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.mock.MockMessage;
import org.smallmind.phalanx.wire.mock.MockMessageListener;
import org.smallmind.phalanx.wire.mock.MockMessageProperties;
import org.smallmind.phalanx.wire.mock.MockMessageRouter;
import org.smallmind.scribe.pen.LoggerManager;

public class MockRequestTransport
extends AbstractRequestTransport {
    private final MockMessageRouter messageRouter;
    private final SignalCodec signalCodec;
    private final String callerId = UUID.randomUUID().toString();

    public MockRequestTransport(MockMessageRouter messageRouter, final SignalCodec signalCodec, int defaultTimeoutSeconds) {
        super(defaultTimeoutSeconds);
        this.messageRouter = messageRouter;
        this.signalCodec = signalCodec;
        messageRouter.getResponseTopic().addListener(new MockMessageListener(){

            @Override
            public boolean match(MockMessageProperties properties) {
                return properties.getHeader(WireProperty.CALLER_ID.getKey()).equals(MockRequestTransport.this.callerId);
            }

            @Override
            public void handle(MockMessage message) {
                try {
                    MockRequestTransport.this.completeCallback(new String(message.getProperties().getCorrelationId()), signalCodec.decode(message.getBytes(), 0, message.getBytes().length, ResultSignal.class));
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(MockRequestTransport.class).error((Throwable)exception);
                }
            }
        });
    }

    @Override
    public String getCallerId() {
        return this.callerId;
    }

    @Override
    public Object transmit(Voice voice, Address address, Map<String, Object> arguments, WireContext ... contexts) throws Throwable {
        String messageId = UUID.randomUUID().toString();
        boolean inOnly = voice.getConversation().getConversationType().equals((Object)ConversationType.IN_ONLY);
        MockMessage message = new MockMessage(this.signalCodec.encode(new InvocationSignal(inOnly, address, arguments, contexts)));
        if (!inOnly) {
            message.getProperties().setHeader(WireProperty.CALLER_ID.getKey(), this.callerId);
        }
        message.getProperties().setMessageId(messageId);
        message.getProperties().setTimestamp(new Date());
        message.getProperties().setContentType(this.signalCodec.getContentType());
        message.getProperties().setHeader(WireProperty.CLOCK.getKey(), System.currentTimeMillis());
        message.getProperties().setHeader(WireProperty.SERVICE_GROUP.getKey(), voice.getServiceGroup());
        if (voice.getMode().equals((Object)VocalMode.WHISPER)) {
            message.getProperties().setHeader(WireProperty.INSTANCE_ID.getKey(), voice.getInstanceId());
            this.messageRouter.getWhisperRequestTopic().send(message);
        } else {
            this.messageRouter.getTalkRequestQueue().send(message);
        }
        return this.acquireResult(this.signalCodec, address, voice, messageId, inOnly);
    }

    @Override
    public void close() throws Exception {
        this.getCallbackMap().shutdown();
    }
}

