/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.jms;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.phalanx.wire.MetricInteraction;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.jms.ConnectionManager;
import org.smallmind.phalanx.wire.jms.JmsRequestTransport;
import org.smallmind.phalanx.wire.jms.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class ResponseListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JmsRequestTransport requestTransport;
    private final ConnectionManager responseConnectionManager;
    private final Topic responseTopic;
    private final SignalCodec signalCodec;
    private final String selector;
    private final byte[] buffer;

    public ResponseListener(JmsRequestTransport requestTransport, ConnectionManager responseConnectionManager, Topic responseTopic, SignalCodec signalCodec, String callerId, int maximumMessageLength) throws JMSException {
        this.requestTransport = requestTransport;
        this.responseConnectionManager = responseConnectionManager;
        this.responseTopic = responseTopic;
        this.signalCodec = signalCodec;
        this.buffer = new byte[maximumMessageLength];
        this.selector = WireProperty.CALLER_ID.getKey() + "='" + callerId + "'";
        responseConnectionManager.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.responseTopic;
    }

    @Override
    public String getMessageSelector() {
        return this.selector;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.responseConnectionManager.stop();
            this.responseConnectionManager.close();
        }
    }

    public void onMessage(final Message message) {
        try {
            long timeInTopic = System.currentTimeMillis() - message.getLongProperty(WireProperty.CLOCK.getKey());
            LoggerManager.getLogger(ResponseListener.class).debug("response message received(%s) in %d ms...", new Object[]{message.getJMSMessageID(), timeInTopic});
            InstrumentationManager.instrumentWithChronometer((MetricConfiguration)this.requestTransport.getMetricConfiguration(), (long)(timeInTopic >= 0L ? timeInTopic : 0L), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("queue", MetricInteraction.RESPONSE_TRANSIT_TIME.getDisplay())});
            InstrumentationManager.execute((Instrument)new ChronometerInstrument(this.requestTransport.getMetricConfiguration(), new MetricProperty[]{new MetricProperty("event", MetricInteraction.COMPLETE_CALLBACK.getDisplay())}){

                public void withChronometer() throws Exception {
                    if (((BytesMessage)message).getBodyLength() > (long)ResponseListener.this.buffer.length) {
                        throw new TransportException("Message length exceeds maximum capacity %d > %d", ((BytesMessage)message).getBodyLength(), ResponseListener.this.buffer.length);
                    }
                    ((BytesMessage)message).readBytes(ResponseListener.this.buffer);
                    ResponseListener.this.requestTransport.completeCallback(message.getJMSCorrelationID(), ResponseListener.this.signalCodec.decode(ResponseListener.this.buffer, 0, (int)((BytesMessage)message).getBodyLength(), ResultSignal.class));
                }
            });
        }
        catch (Exception exception) {
            LoggerManager.getLogger(ResponseListener.class).error((Throwable)exception);
        }
    }
}

