/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.smallmind.nutsnbolts.context.Context;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.phalanx.wire.Function;
import org.smallmind.phalanx.wire.Methodology;
import org.smallmind.phalanx.wire.MissingInvocationException;
import org.smallmind.phalanx.wire.ServiceDefinitionException;
import org.smallmind.phalanx.wire.SyntheticArgument;
import org.smallmind.phalanx.wire.WireContext;

public class MethodInvoker {
    private static final Class[] EMPTY_SIGNATURE = new Class[0];
    private static final Class[] OBJECT_SIGNATURE = new Class[]{Object.class};
    private final HashMap<Function, Methodology> methodMap;
    private final Class<?> serviceInterface;
    private final Object targetObject;

    public MethodInvoker(Object targetObject, Class<?> serviceInterface) throws NoSuchMethodException, ServiceDefinitionException {
        this.targetObject = targetObject;
        this.serviceInterface = serviceInterface;
        this.methodMap = new HashMap();
        for (Method method : serviceInterface.getMethods()) {
            this.methodMap.put(new Function(method), new Methodology(serviceInterface, method, new SyntheticArgument[0]));
        }
        Class<?> endpointClass = targetObject.getClass();
        Method toStringMethod = endpointClass.getMethod("toString", EMPTY_SIGNATURE);
        Method hashCodeMethod = endpointClass.getMethod("hashCode", EMPTY_SIGNATURE);
        Method equalsMethod = endpointClass.getMethod("equals", OBJECT_SIGNATURE);
        this.methodMap.put(new Function(toStringMethod), new Methodology(serviceInterface, toStringMethod, new SyntheticArgument[0]));
        this.methodMap.put(new Function(hashCodeMethod), new Methodology(serviceInterface, hashCodeMethod, new SyntheticArgument[0]));
        this.methodMap.put(new Function(equalsMethod), new Methodology(serviceInterface, equalsMethod, new SyntheticArgument("obj", Object.class)));
    }

    public Function match(Function partialFunction) {
        for (Function function : this.methodMap.keySet()) {
            if (!function.getName().equals(partialFunction.getName()) || partialFunction.getSignature() != null && !Arrays.equals(partialFunction.getSignature(), function.getSignature()) || partialFunction.getResultType() != null && !partialFunction.getResultType().equals(function.getResultType())) continue;
            return function;
        }
        return null;
    }

    public Methodology getMethodology(Function function) throws MissingInvocationException {
        Methodology methodology = this.methodMap.get(function);
        if (methodology == null) {
            throw new MissingInvocationException("No method(%s) available in service interface(%s)", function.getName(), this.serviceInterface.getName());
        }
        return methodology;
    }

    public Object remoteInvocation(WireContext[] contexts, Function function, Object ... arguments) throws Exception {
        Methodology methodology = this.methodMap.get(function);
        if (methodology == null) {
            throw new MissingInvocationException("No method(%s) available in service interface(%s)", function.getName(), this.serviceInterface.getName());
        }
        if (contexts != null && contexts.length > 0) {
            for (WireContext context : contexts) {
                if (context == null) continue;
                ContextFactory.pushContext((Context)context);
            }
        }
        try {
            Object object = methodology.getMethod().invoke(this.targetObject, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof Exception) {
                throw (Exception)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
        finally {
            if (contexts != null && contexts.length > 0) {
                for (WireContext context : contexts) {
                    if (context == null) continue;
                    ContextFactory.popContext(context.getClass());
                }
            }
        }
    }
}

