/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.worker;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.phalanx.worker.MetricInteraction;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class Worker<T>
implements Runnable,
MetricConfigurationProvider {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final MetricConfiguration metricConfiguration;
    private final WorkQueue<T> workQueue;

    public Worker(MetricConfiguration metricConfiguration, WorkQueue<T> workQueue) {
        this.metricConfiguration = metricConfiguration;
        this.workQueue = workQueue;
    }

    public abstract void engageWork(T var1) throws Exception;

    public abstract void close() throws Exception;

    public MetricConfiguration getMetricConfiguration() {
        return this.metricConfiguration;
    }

    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            this.close();
        }
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
        try {
            while (!this.stopped.get()) {
                try {
                    T transfer = this.workQueue.poll(1L, TimeUnit.SECONDS);
                    if (transfer == null) continue;
                    InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)this, (long)(Clocks.EPOCH.getClock().getTimeNanoseconds() - idleStart), (TimeUnit)TimeUnit.NANOSECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("event", MetricInteraction.WORKER_IDLE.getDisplay())});
                    this.engageWork(transfer);
                }
                catch (Throwable throwable) {
                    LoggerManager.getLogger(this.getClass()).error(throwable);
                }
                finally {
                    idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
                }
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

