/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.phalanx.wire.ResultSignal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.SignatureUtility;
import org.smallmind.phalanx.wire.TransmissionCallback;
import org.smallmind.phalanx.wire.TransportTimeoutException;

public class AsynchronousTransmissionCallback
extends TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<Stint> timeoutDurationRef = new AtomicReference();
    private final AtomicReference<ResultSignal> resultSignalRef = new AtomicReference();
    private String serviceName;
    private String functionName;

    public AsynchronousTransmissionCallback(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    public void destroy(Stint timeoutStint) {
        this.timeoutDurationRef.set(timeoutStint);
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult(SignalCodec signalCodec) throws Throwable {
        this.resultLatch.await();
        ResultSignal resultSignal = this.resultSignalRef.get();
        if (resultSignal == null) {
            Stint timeoutStint = this.timeoutDurationRef.get();
            throw new TransportTimeoutException("The timeout(%s) milliseconds was exceeded while waiting for a response(%s.%s)", timeoutStint == null ? "unknown" : String.valueOf(timeoutStint.toMilliseconds()), this.serviceName, this.functionName);
        }
        this.handleError(signalCodec, resultSignal);
        return signalCodec.extractObject(resultSignal.getResult(), SignatureUtility.nativeDecode(resultSignal.getNativeType()));
    }

    public void setResultSignal(ResultSignal resultSignal) {
        this.resultSignalRef.set(resultSignal);
        this.resultLatch.countDown();
    }
}

