/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.amqp.rabbitmq.spring;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import org.smallmind.phalanx.wire.amqp.rabbitmq.RabbitMQConnector;
import org.smallmind.phalanx.wire.amqp.rabbitmq.spring.RabbitMQServer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RabbitMQConnectorFactoryBean
implements FactoryBean<RabbitMQConnector>,
InitializingBean {
    private RabbitMQConnector rabbitMQConnector;
    private RabbitMQServer[] servers;
    private String username;
    private String password;
    private int heartbeatSeconds;

    public void setServers(RabbitMQServer[] servers) {
        this.servers = servers;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHeartbeatSeconds(int heartbeatSeconds) {
        this.heartbeatSeconds = heartbeatSeconds;
    }

    public Class<?> getObjectType() {
        return RabbitMQConnector.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public RabbitMQConnector getObject() {
        return this.rabbitMQConnector;
    }

    public void afterPropertiesSet() {
        int addressIndex = 0;
        Address[] addresses = new Address[this.servers.length];
        for (RabbitMQServer server : this.servers) {
            addresses[addressIndex++] = new Address(server.getHost(), server.getPort());
        }
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setRequestedHeartbeat(this.heartbeatSeconds);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        this.rabbitMQConnector = new RabbitMQConnector(connectionFactory, addresses);
    }
}

