/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.smallmind.phalanx.wire.Signal;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class JsonSignalCodec
implements SignalCodec {
    private Level verboseLogLevel = Level.DEBUG;
    private boolean verbose = false;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerboseLogLevel(Level verboseLogLevel) {
        this.verboseLogLevel = verboseLogLevel;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public byte[] encode(Signal signal) throws JsonProcessingException {
        byte[] bytes = JsonCodec.writeAsBytes((Object)signal);
        if (this.verbose) {
            LoggerManager.getLogger(JsonSignalCodec.class).log(this.verboseLogLevel, "=>%s", new Object[]{new StringConverter(bytes)});
        }
        return bytes;
    }

    @Override
    public <S extends Signal> S decode(byte[] buffer, int offset, int len, Class<S> signalClass) throws IOException {
        if (this.verbose) {
            LoggerManager.getLogger(JsonSignalCodec.class).log(this.verboseLogLevel, "<=%s", new Object[]{new StringConverter(buffer, offset, len)});
        }
        return (S)((Signal)JsonCodec.read((byte[])buffer, (int)offset, (int)len, signalClass));
    }

    @Override
    public <T> T extractObject(Object value, Class<T> clazz) {
        return (T)JsonCodec.convert((Object)value, clazz);
    }

    private class StringConverter {
        private final byte[] buffer;
        private final int offset;
        private final int len;

        public StringConverter(byte[] buffer) {
            this(buffer, 0, buffer.length);
        }

        public StringConverter(byte[] buffer, int offset, int len) {
            this.buffer = buffer;
            this.offset = offset;
            this.len = len;
        }

        public String toString() {
            return new String(this.buffer, this.offset, this.len);
        }
    }
}

