/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.amqp.rabbitmq;

import java.util.Map;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.ResponseTransport;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.WireInvocationCircuit;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.amqp.rabbitmq.RabbitMQMessage;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;

public class InvocationWorker
extends Worker<RabbitMQMessage> {
    private static final String CALLER_ID_AMQP_KEY = "x-opt-" + WireProperty.CALLER_ID.getKey();
    private final ResponseTransport responseTransport;
    private final WireInvocationCircuit invocationCircuit;
    private final SignalCodec signalCodec;

    public InvocationWorker(MetricConfiguration metricConfiguration, WorkQueue<RabbitMQMessage> workQueue, ResponseTransport responseTransport, WireInvocationCircuit invocationCircuit, SignalCodec signalCodec) {
        super(metricConfiguration, workQueue);
        this.responseTransport = responseTransport;
        this.invocationCircuit = invocationCircuit;
        this.signalCodec = signalCodec;
    }

    @Override
    public void engageWork(final RabbitMQMessage message) throws Exception {
        final InvocationSignal invocationSignal = this.signalCodec.decode(message.getBody(), 0, message.getBody().length, InvocationSignal.class);
        InstrumentationManager.execute((Instrument)new ChronometerInstrument(this.getMetricConfiguration(), new MetricProperty[]{new MetricProperty("operation", "invoke"), new MetricProperty("service", invocationSignal.getRoute().getService()), new MetricProperty("method", invocationSignal.getRoute().getFunction().getName())}){

            public void withChronometer() {
                InvocationWorker.this.invocationCircuit.handle(InvocationWorker.this.responseTransport, InvocationWorker.this.signalCodec, InvocationWorker.this.getCallerId(message.getProperties().getHeaders()), message.getProperties().getMessageId(), invocationSignal);
            }
        });
    }

    private String getCallerId(Map<String, Object> headers) {
        if (headers != null && headers.containsKey(CALLER_ID_AMQP_KEY)) {
            return headers.get(CALLER_ID_AMQP_KEY).toString();
        }
        return null;
    }

    @Override
    public void close() {
    }
}

