/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.ResponseTransport;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.WireInvocationCircuit;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;

public class InvocationWorker
extends Worker<Message> {
    private final ResponseTransport responseTransport;
    private final WireInvocationCircuit invocationCircuit;
    private final SignalCodec signalCodec;
    private final byte[] buffer;

    public InvocationWorker(MetricConfiguration metricConfiguration, WorkQueue<Message> workQueue, ResponseTransport responseTransport, WireInvocationCircuit invocationCircuit, SignalCodec signalCodec, int maximumMessageLength) {
        super(metricConfiguration, workQueue);
        this.responseTransport = responseTransport;
        this.invocationCircuit = invocationCircuit;
        this.signalCodec = signalCodec;
        this.buffer = new byte[maximumMessageLength];
    }

    @Override
    public void engageWork(final Message message) throws Exception {
        if (((BytesMessage)message).getBodyLength() > (long)this.buffer.length) {
            throw new TransportException("Message length exceeds maximum capacity %d > %d", ((BytesMessage)message).getBodyLength(), this.buffer.length);
        }
        ((BytesMessage)message).readBytes(this.buffer);
        final InvocationSignal invocationSignal = this.signalCodec.decode(this.buffer, 0, (int)((BytesMessage)message).getBodyLength(), InvocationSignal.class);
        InstrumentationManager.execute((Instrument)new ChronometerInstrument(this.getMetricConfiguration(), new MetricProperty[]{new MetricProperty("operation", "invoke"), new MetricProperty("service", invocationSignal.getRoute().getService()), new MetricProperty("method", invocationSignal.getRoute().getFunction().getName())}){

            public void withChronometer() throws JMSException {
                InvocationWorker.this.invocationCircuit.handle(InvocationWorker.this.responseTransport, InvocationWorker.this.signalCodec, message.getStringProperty(WireProperty.CALLER_ID.getKey()), message.getJMSMessageID(), invocationSignal);
            }
        });
    }

    @Override
    public void close() {
    }
}

