/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.smallmind.phalanx.wire.Argument;
import org.smallmind.phalanx.wire.ArgumentInfo;
import org.smallmind.phalanx.wire.ServiceDefinitionException;
import org.smallmind.phalanx.wire.SyntheticArgument;

public class Methodology {
    private final Method method;
    private final HashMap<String, ArgumentInfo> argumentInfoMap = new HashMap();

    public Methodology(Class<?> serviceInterface, Method method, SyntheticArgument ... syntheticArguments) throws ServiceDefinitionException {
        int index = 0;
        this.method = method;
        if (syntheticArguments != null && syntheticArguments.length > 0) {
            for (SyntheticArgument syntheticArgument : syntheticArguments) {
                this.argumentInfoMap.put(syntheticArgument.getName(), new ArgumentInfo(index++, syntheticArgument.getParameterType()));
            }
        } else {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            block1: for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                    if (!annotation.annotationType().equals(Argument.class)) continue;
                    this.argumentInfoMap.put(((Argument)annotation).value(), new ArgumentInfo(index, method.getParameterTypes()[index++]));
                    continue block1;
                }
            }
        }
        if (index != method.getParameterTypes().length) {
            throw new ServiceDefinitionException("The method(%s) of service interface(%s) requires @Argument annotations", method.getName(), serviceInterface.getName());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public ArgumentInfo getArgumentInfo(String name) {
        return this.argumentInfoMap.get(name);
    }
}

