/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.phalanx.wire.ArgumentInfo;
import org.smallmind.phalanx.wire.Function;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.MethodInvoker;
import org.smallmind.phalanx.wire.Methodology;
import org.smallmind.phalanx.wire.MismatchedArgumentException;
import org.smallmind.phalanx.wire.MissingInvocationException;
import org.smallmind.phalanx.wire.ResponseTransport;
import org.smallmind.phalanx.wire.ServiceDefinitionException;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.WiredService;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.json.scaffold.fault.Fault;
import org.smallmind.web.json.scaffold.fault.FaultElement;
import org.smallmind.web.json.scaffold.fault.FaultWrappingException;

public class WireInvocationCircuit {
    private final ConcurrentHashMap<ServiceKey, MethodInvoker> invokerMap = new ConcurrentHashMap();

    public void register(Class<?> serviceInterface, WiredService targetService) throws NoSuchMethodException, ServiceDefinitionException {
        this.invokerMap.putIfAbsent(new ServiceKey(targetService.getVersion(), targetService.getServiceName()), new MethodInvoker(targetService, serviceInterface));
    }

    public void handle(ResponseTransport transport, SignalCodec signalCodec, String callerId, String messageId, InvocationSignal invocationSignal) {
        Object result = null;
        String nativeType = null;
        boolean error = false;
        try {
            block13: {
                try {
                    MethodInvoker methodInvoker = this.invokerMap.get(new ServiceKey(invocationSignal.getRoute().getVersion(), invocationSignal.getRoute().getService()));
                    if (methodInvoker == null) {
                        throw new ServiceDefinitionException("Unregistered service(version = %d, name = %s)", invocationSignal.getRoute().getVersion(), invocationSignal.getRoute().getService());
                    }
                    Function invocationFunction = invocationSignal.getRoute().getFunction();
                    if (invocationFunction.isPartial()) {
                        Function completeFunction = methodInvoker.match(invocationFunction);
                        if (completeFunction == null) {
                            throw new MissingInvocationException("Unable to locate the proper method for the partial function(%s) of service(%s)", invocationFunction.getName(), invocationSignal.getRoute().getService());
                        }
                        invocationFunction = completeFunction;
                    }
                    Methodology methodology = methodInvoker.getMethodology(invocationFunction);
                    Object[] arguments = new Object[invocationFunction.getSignature().length];
                    if (invocationSignal.getArguments() != null) {
                        for (Map.Entry<String, Object> argumentEntry : invocationSignal.getArguments().entrySet()) {
                            ArgumentInfo argumentInfo = methodology.getArgumentInfo(argumentEntry.getKey());
                            if (argumentInfo == null) {
                                throw new MismatchedArgumentException("Invocation argument(%s) on method(%s) of service(%s) can't be matched by name", argumentEntry.getKey(), invocationFunction.getName(), invocationSignal.getRoute().getService());
                            }
                            if (argumentInfo.getIndex() >= arguments.length) {
                                throw new MismatchedArgumentException("Invocation argument(%s) on method(%s) of service(%s) maps to a non-existent argument index(%d)", argumentEntry.getKey(), invocationFunction.getName(), invocationSignal.getRoute().getService(), argumentInfo.getIndex());
                            }
                            arguments[argumentInfo.getIndex()] = signalCodec.extractObject(argumentEntry.getValue(), argumentInfo.getParameterType());
                        }
                    }
                    nativeType = invocationFunction.getNativeType();
                    result = methodInvoker.remoteInvocation(invocationSignal.getContexts(), invocationFunction, arguments);
                    if (result != null && !(result instanceof Serializable)) {
                        throw new TransportException("The result(%s) of this call is not Serializable", result.getClass().getName());
                    }
                }
                catch (Exception exception) {
                    if (invocationSignal.isInOnly()) break block13;
                    error = true;
                    Object object = result = exception instanceof FaultWrappingException ? ((FaultWrappingException)exception).getFault() : new Fault(new FaultElement(invocationSignal.getRoute().getService(), invocationSignal.getRoute().getFunction().getName()), (Throwable)exception);
                }
            }
            if (!invocationSignal.isInOnly()) {
                transport.transmit(callerId, messageId, error, nativeType, result);
            }
        }
        catch (Throwable throwable) {
            LoggerManager.getLogger(WireInvocationCircuit.class).error(throwable);
        }
    }

    private static class ServiceKey {
        private final String service;
        private final int version;

        private ServiceKey(int version, String service) {
            this.version = version;
            this.service = service;
        }

        public String getService() {
            return this.service;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return this.service.hashCode() ^ this.version;
        }

        public boolean equals(Object obj) {
            return obj instanceof ServiceKey && ((ServiceKey)obj).getService().equals(this.service) && ((ServiceKey)obj).getVersion() == this.version;
        }
    }
}

