/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.amqp.rabbitmq;

import java.util.Map;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.phalanx.wire.InvocationSignal;
import org.smallmind.phalanx.wire.ResponseTransport;
import org.smallmind.phalanx.wire.SignalCodec;
import org.smallmind.phalanx.wire.WireInvocationCircuit;
import org.smallmind.phalanx.wire.WireProperty;
import org.smallmind.phalanx.wire.amqp.rabbitmq.RabbitMQMessage;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;

public class InvocationWorker
extends Worker<RabbitMQMessage> {
    private static final String CALLER_ID_AMQP_KEY = "x-opt-" + WireProperty.CALLER_ID.getKey();
    private final ResponseTransport responseTransport;
    private final WireInvocationCircuit invocationCircuit;
    private final SignalCodec signalCodec;

    public InvocationWorker(WorkQueue<RabbitMQMessage> workQueue, ResponseTransport responseTransport, WireInvocationCircuit invocationCircuit, SignalCodec signalCodec) {
        super(workQueue);
        this.responseTransport = responseTransport;
        this.invocationCircuit = invocationCircuit;
        this.signalCodec = signalCodec;
    }

    @Override
    public void engageWork(RabbitMQMessage message) throws Throwable {
        InvocationSignal invocationSignal = this.signalCodec.decode(message.getBody(), 0, message.getBody().length, InvocationSignal.class);
        Instrument.with(InvocationWorker.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("operation", "invoke"), new Tag("service", invocationSignal.getRoute().getService()), new Tag("method", invocationSignal.getRoute().getFunction().getName())}).on(() -> this.invocationCircuit.handle(this.responseTransport, this.signalCodec, this.getCallerId(message.getProperties().getHeaders()), message.getProperties().getMessageId(), invocationSignal));
    }

    private String getCallerId(Map<String, Object> headers) {
        if (headers != null && headers.containsKey(CALLER_ID_AMQP_KEY)) {
            return headers.get(CALLER_ID_AMQP_KEY).toString();
        }
        return null;
    }

    @Override
    public void close() {
    }
}

