/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.smallmind.nutsnbolts.context.Context;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.phalanx.wire.Argument;
import org.smallmind.phalanx.wire.InOnly;
import org.smallmind.phalanx.wire.InOut;
import org.smallmind.phalanx.wire.MissingInvocationException;
import org.smallmind.phalanx.wire.OneWayConversation;
import org.smallmind.phalanx.wire.ParameterExtractor;
import org.smallmind.phalanx.wire.ServiceDefinitionException;
import org.smallmind.phalanx.wire.Shout;
import org.smallmind.phalanx.wire.Shouting;
import org.smallmind.phalanx.wire.Talking;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.TwoWayConversation;
import org.smallmind.phalanx.wire.Voice;
import org.smallmind.phalanx.wire.Whisper;
import org.smallmind.phalanx.wire.Whispering;
import org.smallmind.phalanx.wire.signal.Function;
import org.smallmind.phalanx.wire.signal.Route;
import org.smallmind.phalanx.wire.signal.WireContext;
import org.smallmind.phalanx.wire.transport.RequestTransport;

public class WireInvocationHandler
implements InvocationHandler {
    private static final Class[] EMPTY_SIGNATURE = new Class[0];
    private static final Class[] OBJECT_SIGNATURE = new Class[]{Object.class};
    private static final String[] NO_NAMES = new String[0];
    private static final String[] SINGLE_OBJECT_NAME = new String[]{"obj"};
    private static final OneWayConversation ONE_WAY_CONVERSATION = new OneWayConversation();
    private final RequestTransport transport;
    private final HashMap<Method, String[]> methodMap = new HashMap();
    private final ParameterExtractor<String> serviceGroupExtractor;
    private final ParameterExtractor<String> instanceIdExtractor;
    private final ParameterExtractor<Integer> timeoutExtractor;
    private final Class<?> serviceInterface;
    private final String serviceName;
    private final int version;

    public WireInvocationHandler(RequestTransport transport, int version, String serviceName, Class<?> serviceInterface, ParameterExtractor<String> serviceGroupExtractor, ParameterExtractor<String> instanceIdExtractor, ParameterExtractor<Integer> timeoutExtractor) throws Exception {
        this.transport = transport;
        this.version = version;
        this.serviceName = serviceName;
        this.serviceInterface = serviceInterface;
        this.serviceGroupExtractor = serviceGroupExtractor;
        this.timeoutExtractor = timeoutExtractor;
        this.instanceIdExtractor = instanceIdExtractor;
        if (serviceGroupExtractor == null) {
            throw new ServiceDefinitionException("The service interface(%s) has no service group extractor %s is defined", serviceInterface.getName(), ParameterExtractor.class.getSimpleName());
        }
        for (Method method : serviceInterface.getMethods()) {
            String[] argumentNames = new String[method.getParameterTypes().length];
            int index = 0;
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            block7: for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                    if (!annotation.annotationType().equals(Argument.class)) continue;
                    argumentNames[index++] = ((Argument)annotation).value();
                    continue block7;
                }
            }
            if (index != argumentNames.length) {
                throw new ServiceDefinitionException("The method(%s) of service interface(%s) requires @Argument annotations", method.getName(), serviceInterface.getName());
            }
            this.methodMap.put(method, argumentNames);
        }
        try {
            serviceInterface.getMethod("toString", EMPTY_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.methodMap.put(Object.class.getMethod("toString", EMPTY_SIGNATURE), NO_NAMES);
        }
        try {
            serviceInterface.getMethod("hashCode", EMPTY_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.methodMap.put(Object.class.getMethod("hashCode", EMPTY_SIGNATURE), NO_NAMES);
        }
        try {
            serviceInterface.getMethod("equals", OBJECT_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.methodMap.put(Object.class.getMethod("equals", OBJECT_SIGNATURE), SINGLE_OBJECT_NAME);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Voice<String, Void> voice;
        Context[] filteredContexts;
        int index;
        HashMap<String, Object> argumentMap = null;
        WireContext[] wireContexts = null;
        String[] argumentNames = this.methodMap.get(method);
        if (argumentNames == null) {
            throw new MissingInvocationException("No method(%s) available in the service interface(%s)", method.getName(), this.serviceInterface.getName());
        }
        if (argumentNames.length != (args == null ? 0 : args.length)) {
            throw new ServiceDefinitionException("The arguments for method(%s) in the service interface(%s) do not match those known from the service interface annotations", method.getName(), this.serviceInterface.getName());
        }
        if (args != null && args.length > 0) {
            argumentMap = new HashMap<String, Object>();
            for (index = 0; index < args.length; ++index) {
                if (args[index] != null && !(args[index] instanceof Serializable)) {
                    throw new TransportException("The argument(index=%d, name=%s, class=%s) is not Serializable", index, argumentNames[index], args[index].getClass().getName());
                }
                argumentMap.put(argumentNames[index], args[index]);
            }
        }
        if ((filteredContexts = ContextFactory.filterContextsOn((Method)method, (Class[])new Class[]{WireContext.class})) != null) {
            index = 0;
            wireContexts = new WireContext[filteredContexts.length];
            for (Context filteredContext : filteredContexts) {
                wireContexts[index++] = (WireContext)filteredContext;
            }
        }
        if (method.getAnnotation(Shout.class) != null) {
            voice = new Shouting(this.serviceGroupExtractor.getParameter(method, argumentMap, wireContexts));
        } else {
            Whisper whisper = method.getAnnotation(Whisper.class);
            if (whisper != null) {
                if (this.instanceIdExtractor == null) {
                    throw new ServiceDefinitionException("The method(%s) in service interface(%s) is marked as @Whisper but no instance id extractor %s is defined", method.getName(), this.serviceInterface.getName(), ParameterExtractor.class.getSimpleName());
                }
                Integer timeoutSeconds = null;
                if (this.timeoutExtractor != null) {
                    timeoutSeconds = this.timeoutExtractor.getParameter(method, argumentMap, wireContexts);
                }
                if (timeoutSeconds == null) {
                    timeoutSeconds = whisper.timeoutSeconds();
                }
                voice = new Whispering(this.serviceGroupExtractor.getParameter(method, argumentMap, wireContexts), this.instanceIdExtractor.getParameter(method, argumentMap, wireContexts), timeoutSeconds);
            } else if (method.getAnnotation(InOnly.class) != null) {
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new ServiceDefinitionException("The method(%s) in service interface(%s) is marked as @InOnly but does not return 'void'", method.getName(), this.serviceInterface.getName());
                }
                if (method.getExceptionTypes().length > 0) {
                    throw new ServiceDefinitionException("The method(%s) in service interface(%s) is marked as @InOnly but declares an Exception list", method.getName(), this.serviceInterface.getName());
                }
                voice = new Talking(ONE_WAY_CONVERSATION, this.serviceGroupExtractor.getParameter(method, argumentMap, wireContexts));
            } else {
                InOut inOut = method.getAnnotation(InOut.class);
                Integer timeoutSeconds = null;
                if (this.timeoutExtractor != null) {
                    timeoutSeconds = this.timeoutExtractor.getParameter(method, argumentMap, wireContexts);
                }
                if (timeoutSeconds == null && inOut != null) {
                    timeoutSeconds = inOut.timeoutSeconds();
                }
                voice = new Talking(new TwoWayConversation(timeoutSeconds), this.serviceGroupExtractor.getParameter(method, argumentMap, wireContexts));
            }
        }
        return this.transport.transmit(voice, new Route(this.version, this.serviceName, new Function(method)), argumentMap, wireContexts);
    }
}

