/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.mock;

import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.phalanx.wire.ServiceDefinitionException;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.ResultSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.ResponseTransmitter;
import org.smallmind.phalanx.wire.transport.ResponseTransport;
import org.smallmind.phalanx.wire.transport.TransportState;
import org.smallmind.phalanx.wire.transport.WireInvocationCircuit;
import org.smallmind.phalanx.wire.transport.WireProperty;
import org.smallmind.phalanx.wire.transport.WiredService;
import org.smallmind.phalanx.wire.transport.mock.MockMessage;
import org.smallmind.phalanx.wire.transport.mock.MockMessageListener;
import org.smallmind.phalanx.wire.transport.mock.MockMessageProperties;
import org.smallmind.phalanx.wire.transport.mock.MockMessageRouter;
import org.smallmind.scribe.pen.LoggerManager;

public class MockResponseTransport
implements ResponseTransport,
ResponseTransmitter {
    private final AtomicReference<TransportState> transportStateRef = new AtomicReference<TransportState>(TransportState.PLAYING);
    private final WireInvocationCircuit invocationCircuit = new WireInvocationCircuit();
    private final MockMessageRouter messageRouter;
    private final SignalCodec signalCodec;
    private final String instanceId = UUID.randomUUID().toString();

    public MockResponseTransport(MockMessageRouter messageRouter, final SignalCodec signalCodec) {
        this.messageRouter = messageRouter;
        this.signalCodec = signalCodec;
        messageRouter.getTalkRequestQueue().addListener(new MockMessageListener(){

            @Override
            public boolean match(MockMessageProperties properties) {
                return true;
            }

            @Override
            public void handle(MockMessage message) {
                try {
                    MockResponseTransport.this.invocationCircuit.handle(MockResponseTransport.this, signalCodec, (String)message.getProperties().getHeader(WireProperty.CALLER_ID.getKey()), message.getProperties().getMessageId(), signalCodec.decode(message.getBytes(), 0, message.getBytes().length, InvocationSignal.class));
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(MockResponseTransport.class).error((Throwable)exception);
                }
            }
        });
        messageRouter.getWhisperRequestTopic().addListener(new MockMessageListener(){

            @Override
            public boolean match(MockMessageProperties properties) {
                return properties.getHeader(WireProperty.INSTANCE_ID.getKey()).equals(MockResponseTransport.this.instanceId);
            }

            @Override
            public void handle(MockMessage message) {
                try {
                    MockResponseTransport.this.invocationCircuit.handle(MockResponseTransport.this, signalCodec, (String)message.getProperties().getHeader(WireProperty.CALLER_ID.getKey()), message.getProperties().getMessageId(), signalCodec.decode(message.getBytes(), 0, message.getBytes().length, InvocationSignal.class));
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(MockResponseTransport.class).error((Throwable)exception);
                }
            }
        });
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String register(Class<?> serviceInterface, WiredService targetService) throws NoSuchMethodException, ServiceDefinitionException {
        this.invocationCircuit.register(serviceInterface, targetService);
        return this.instanceId;
    }

    @Override
    public TransportState getState() {
        return this.transportStateRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        AtomicReference<TransportState> atomicReference = this.transportStateRef;
        synchronized (atomicReference) {
            if (this.transportStateRef.compareAndSet(TransportState.PAUSED, TransportState.PLAYING)) {
                this.messageRouter.getTalkRequestQueue().play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        AtomicReference<TransportState> atomicReference = this.transportStateRef;
        synchronized (atomicReference) {
            if (this.transportStateRef.compareAndSet(TransportState.PLAYING, TransportState.PAUSED)) {
                this.messageRouter.getTalkRequestQueue().pause();
            }
        }
    }

    @Override
    public void transmit(String callerId, String correlationId, boolean error, String nativeType, Object result) throws Exception {
        MockMessage message = new MockMessage(this.signalCodec.encode(new ResultSignal(error, nativeType, result)));
        message.getProperties().setHeader(WireProperty.CALLER_ID.getKey(), callerId);
        message.getProperties().setContentType(this.signalCodec.getContentType());
        message.getProperties().setMessageId(UUID.randomUUID().toString());
        message.getProperties().setTimestamp(new Date());
        message.getProperties().setCorrelationId(correlationId.getBytes());
        this.messageRouter.getResponseTopic().send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        AtomicReference<TransportState> atomicReference = this.transportStateRef;
        synchronized (atomicReference) {
            this.transportStateRef.set(TransportState.CLOSED);
        }
    }
}

