/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.signal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.smallmind.phalanx.wire.Argument;
import org.smallmind.phalanx.wire.CallAs;
import org.smallmind.phalanx.wire.Result;
import org.smallmind.phalanx.wire.SignatureUtility;

@XmlRootElement(name="function", namespace="http://org.smallmind/phalanx/wire")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Function
implements Serializable {
    private String name;
    private String resultType;
    private String nativeType;
    private String[] signature;

    public Function() {
    }

    public Function(String name) {
        this.name = name;
    }

    public Function(String name, String nativeType) {
        this.name = name;
        this.nativeType = nativeType;
    }

    public Function(Method method) {
        CallAs callAs = method.getAnnotation(CallAs.class);
        this.name = callAs == null ? method.getName() : callAs.value();
        Result result = method.getAnnotation(Result.class);
        this.resultType = result == null ? SignatureUtility.neutralEncode(method.getReturnType()) : "!" + result.value();
        Class<?>[] parameterClasses = method.getParameterTypes();
        this.signature = new String[parameterClasses.length];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int index = 0; index < parameterClasses.length; ++index) {
            boolean viaAnnotation = false;
            for (Annotation annotation : parameterAnnotations[index]) {
                if (!annotation.annotationType().equals(Argument.class)) continue;
                String typeHint = ((Argument)annotation).type();
                if (typeHint.length() <= 0) break;
                viaAnnotation = true;
                this.signature[index] = "!" + typeHint;
                break;
            }
            if (viaAnnotation) continue;
            this.signature[index] = SignatureUtility.neutralEncode(parameterClasses[index]);
        }
        this.nativeType = SignatureUtility.nativeEncode(method.getReturnType());
    }

    @XmlTransient
    public boolean isPartial() {
        return this.signature == null || this.resultType == null;
    }

    @XmlElement(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="nativeType")
    public String getNativeType() {
        return this.nativeType;
    }

    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    @XmlElement(name="resultType")
    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    @XmlElement(name="signature")
    public String[] getSignature() {
        return this.signature;
    }

    public void setSignature(String[] signature) {
        this.signature = signature;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.resultType != null) {
            hashCode ^= this.resultType.hashCode();
        }
        if (this.signature != null) {
            for (String parameter : this.signature) {
                hashCode ^= parameter.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof Function && this.name.equals(((Function)obj).getName()) && (this.resultType == null ? ((Function)obj).getResultType() == null : this.resultType.equals(((Function)obj).getResultType())) && Arrays.equals(this.signature, ((Function)obj).getSignature());
    }
}

