/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport;

import java.util.concurrent.TimeUnit;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.nutsnbolts.util.SelfDestructive;
import org.smallmind.nutsnbolts.util.SelfDestructiveMap;
import org.smallmind.phalanx.wire.Voice;
import org.smallmind.phalanx.wire.signal.ResultSignal;
import org.smallmind.phalanx.wire.signal.Route;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.AsynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.transport.RequestTransport;
import org.smallmind.phalanx.wire.transport.SynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.transport.TransmissionCallback;

public abstract class AbstractRequestTransport
implements RequestTransport {
    private final SelfDestructiveMap<String, TransmissionCallback> callbackMap;

    public AbstractRequestTransport(int defaultTimeoutSeconds) {
        this.callbackMap = new SelfDestructiveMap(new Stint((long)defaultTimeoutSeconds, TimeUnit.SECONDS));
    }

    public SelfDestructiveMap<String, TransmissionCallback> getCallbackMap() {
        return this.callbackMap;
    }

    public Object acquireResult(SignalCodec signalCodec, Route route, Voice<?, ?> voice, String messageId, boolean inOnly) throws Throwable {
        if (!inOnly) {
            AsynchronousTransmissionCallback asynchronousCallback = new AsynchronousTransmissionCallback(route.getService(), route.getFunction().getName());
            Object timeoutObject = voice.getConversation().getTimeout();
            int timeoutSeconds = timeoutObject == null ? 0 : (Integer)timeoutObject;
            SynchronousTransmissionCallback previousCallback = (SynchronousTransmissionCallback)this.getCallbackMap().putIfAbsent((Comparable)((Object)messageId), (SelfDestructive)asynchronousCallback, timeoutSeconds > 0 ? new Stint((long)timeoutSeconds, TimeUnit.SECONDS) : null);
            if (previousCallback != null) {
                return previousCallback.getResult(signalCodec);
            }
            return asynchronousCallback.getResult(signalCodec);
        }
        return null;
    }

    @Override
    public void completeCallback(String correlationId, ResultSignal resultSignal) {
        TransmissionCallback previousCallback = (TransmissionCallback)this.callbackMap.get((Comparable)((Object)correlationId));
        if (previousCallback == null) {
            previousCallback = (TransmissionCallback)this.callbackMap.putIfAbsent((Comparable)((Object)correlationId), (SelfDestructive)new SynchronousTransmissionCallback(resultSignal));
            if (previousCallback != null && previousCallback instanceof AsynchronousTransmissionCallback) {
                ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
            }
        } else if (previousCallback instanceof AsynchronousTransmissionCallback) {
            ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
        }
    }
}

