/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.amqp.rabbitmq;

import java.util.Map;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.ResponseTransmitter;
import org.smallmind.phalanx.wire.transport.WireInvocationCircuit;
import org.smallmind.phalanx.wire.transport.WireProperty;
import org.smallmind.phalanx.wire.transport.amqp.rabbitmq.RabbitMQMessage;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;

public class InvocationWorker
extends Worker<RabbitMQMessage> {
    private static final String CALLER_ID_AMQP_KEY = "x-opt-" + WireProperty.CALLER_ID.getKey();
    private final ResponseTransmitter responseTransmitter;
    private final WireInvocationCircuit invocationCircuit;
    private final SignalCodec signalCodec;

    public InvocationWorker(WorkQueue<RabbitMQMessage> workQueue, ResponseTransmitter responseTransmitter, WireInvocationCircuit invocationCircuit, SignalCodec signalCodec) {
        super(workQueue);
        this.responseTransmitter = responseTransmitter;
        this.invocationCircuit = invocationCircuit;
        this.signalCodec = signalCodec;
    }

    @Override
    public void engageWork(RabbitMQMessage message) throws Throwable {
        InvocationSignal invocationSignal = this.signalCodec.decode(message.getBody(), 0, message.getBody().length, InvocationSignal.class);
        Instrument.with(InvocationWorker.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("operation", "invoke"), new Tag("service", invocationSignal.getRoute().getService()), new Tag("method", invocationSignal.getRoute().getFunction().getName())}).on(() -> this.invocationCircuit.handle(this.responseTransmitter, this.signalCodec, this.getCallerId(message.getProperties().getHeaders()), message.getProperties().getMessageId(), invocationSignal));
    }

    private String getCallerId(Map<String, Object> headers) {
        if (headers != null && headers.containsKey(CALLER_ID_AMQP_KEY)) {
            return headers.get(CALLER_ID_AMQP_KEY).toString();
        }
        return null;
    }

    @Override
    public void close() {
    }
}

