/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.phalanx.wire.ConversationType;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.VocalMode;
import org.smallmind.phalanx.wire.Voice;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.Route;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.signal.WireContext;
import org.smallmind.phalanx.wire.transport.AbstractRequestTransport;
import org.smallmind.phalanx.wire.transport.ClaxonTag;
import org.smallmind.phalanx.wire.transport.WireProperty;
import org.smallmind.phalanx.wire.transport.jms.ConnectionManager;
import org.smallmind.phalanx.wire.transport.jms.MessageHandler;
import org.smallmind.phalanx.wire.transport.jms.MessagePolicy;
import org.smallmind.phalanx.wire.transport.jms.QueueOperator;
import org.smallmind.phalanx.wire.transport.jms.ReconnectionPolicy;
import org.smallmind.phalanx.wire.transport.jms.ResponseListener;
import org.smallmind.phalanx.wire.transport.jms.RoutingFactories;
import org.smallmind.phalanx.wire.transport.jms.TopicOperator;

public class JmsRequestTransport
extends AbstractRequestTransport {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final SignalCodec signalCodec;
    private final LinkedBlockingQueue<MessageHandler> talkQueue;
    private final LinkedBlockingQueue<MessageHandler> whisperAndShoutQueue;
    private final ConnectionManager[] talkRequestConnectionManagers;
    private final ConnectionManager[] whisperAndShoutRequestConnectionManagers;
    private final ResponseListener[] responseListeners;
    private final String callerId = SnowflakeId.newInstance().generateDottedString();

    public JmsRequestTransport(RoutingFactories routingFactories, MessagePolicy messagePolicy, ReconnectionPolicy reconnectionPolicy, SignalCodec signalCodec, int clusterSize, int concurrencyLimit, int maximumMessageLength, int defaultTimeoutSeconds) throws JMSException, TransportException {
        super(defaultTimeoutSeconds);
        int index;
        int talkIndex = 0;
        int whisperIndex = 0;
        this.signalCodec = signalCodec;
        this.talkRequestConnectionManagers = new ConnectionManager[clusterSize];
        for (index = 0; index < this.talkRequestConnectionManagers.length; ++index) {
            this.talkRequestConnectionManagers[index] = new ConnectionManager(routingFactories.getRequestQueueFactory(), messagePolicy, reconnectionPolicy);
        }
        this.whisperAndShoutRequestConnectionManagers = new ConnectionManager[clusterSize];
        for (index = 0; index < this.whisperAndShoutRequestConnectionManagers.length; ++index) {
            this.whisperAndShoutRequestConnectionManagers[index] = new ConnectionManager(routingFactories.getRequestTopicFactory(), messagePolicy, reconnectionPolicy);
        }
        this.talkQueue = new LinkedBlockingQueue();
        for (index = 0; index < Math.max(clusterSize, concurrencyLimit); ++index) {
            this.talkQueue.add(new QueueOperator(this.talkRequestConnectionManagers[talkIndex], (Queue)routingFactories.getRequestQueueFactory().getDestination()));
            if (++talkIndex != this.talkRequestConnectionManagers.length) continue;
            talkIndex = 0;
        }
        this.whisperAndShoutQueue = new LinkedBlockingQueue();
        for (index = 0; index < Math.max(clusterSize, concurrencyLimit); ++index) {
            this.whisperAndShoutQueue.add(new TopicOperator(this.whisperAndShoutRequestConnectionManagers[whisperIndex], (Topic)routingFactories.getRequestTopicFactory().getDestination()));
            if (++whisperIndex != this.whisperAndShoutRequestConnectionManagers.length) continue;
            whisperIndex = 0;
        }
        this.responseListeners = new ResponseListener[clusterSize];
        for (index = 0; index < this.responseListeners.length; ++index) {
            this.responseListeners[index] = new ResponseListener(this, new ConnectionManager(routingFactories.getResponseTopicFactory(), messagePolicy, reconnectionPolicy), (Topic)routingFactories.getResponseTopicFactory().getDestination(), signalCodec, this.callerId, maximumMessageLength);
        }
    }

    @Override
    public String getCallerId() {
        return this.callerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object transmit(Voice<?, ?> voice, Route route, Map<String, Object> arguments, WireContext ... contexts) throws Throwable {
        LinkedBlockingQueue<MessageHandler> messageQueue = voice.getMode().equals((Object)VocalMode.TALK) ? this.talkQueue : this.whisperAndShoutQueue;
        MessageHandler messageHandler = this.acquireMessageHandler(messageQueue);
        boolean inOnly = voice.getConversation().getConversationType().equals((Object)ConversationType.IN_ONLY);
        try {
            Message requestMessage = this.constructMessage(messageHandler, inOnly, (String)voice.getServiceGroup(), voice.getMode().equals((Object)VocalMode.WHISPER) ? (String)voice.getInstanceId() : null, route, arguments, contexts);
            messageHandler.send(requestMessage);
            String messageId = requestMessage.getJMSMessageID();
            Object object = Instrument.with(JmsRequestTransport.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("event", ClaxonTag.ACQUIRE_RESULT.getDisplay())}).on(() -> this.acquireResult(this.signalCodec, route, voice, messageId, inOnly));
            return object;
        }
        finally {
            messageQueue.put(messageHandler);
        }
    }

    private MessageHandler acquireMessageHandler(LinkedBlockingQueue<MessageHandler> messageHandlerQueue) throws Throwable {
        return (MessageHandler)Instrument.with(JmsRequestTransport.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("event", ClaxonTag.ACQUIRE_REQUEST_TRANSPORT.getDisplay())}).on(() -> {
            MessageHandler messageHandler;
            do {
                messageHandler = (MessageHandler)messageHandlerQueue.poll(1L, TimeUnit.SECONDS);
            } while (!this.closed.get() && messageHandler == null);
            if (messageHandler == null) {
                throw new TransportException("Message transmission has been closed", new Object[0]);
            }
            return messageHandler;
        });
    }

    private Message constructMessage(MessageHandler messageHandler, boolean inOnly, String serviceGroup, String instanceId, Route route, Map<String, Object> arguments, WireContext ... contexts) throws Throwable {
        return (Message)Instrument.with(JmsRequestTransport.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("event", ClaxonTag.CONSTRUCT_MESSAGE.getDisplay())}).on(() -> {
            BytesMessage requestMessage = messageHandler.createMessage();
            requestMessage.writeBytes(this.signalCodec.encode(new InvocationSignal(inOnly, route, arguments, contexts)));
            if (!inOnly) {
                requestMessage.setStringProperty(WireProperty.CALLER_ID.getKey(), this.callerId);
            }
            requestMessage.setStringProperty(WireProperty.CONTENT_TYPE.getKey(), this.signalCodec.getContentType());
            requestMessage.setLongProperty(WireProperty.CLOCK.getKey(), System.currentTimeMillis());
            requestMessage.setStringProperty(WireProperty.SERVICE_GROUP.getKey(), serviceGroup);
            if (instanceId != null) {
                requestMessage.setStringProperty(WireProperty.INSTANCE_ID.getKey(), instanceId);
            }
            return requestMessage;
        });
    }

    @Override
    public void close() throws JMSException, InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            for (ConnectionManager requestConnectionManager : this.whisperAndShoutRequestConnectionManagers) {
                requestConnectionManager.stop();
            }
            for (ConnectionManager requestConnectionManager : this.talkRequestConnectionManagers) {
                requestConnectionManager.stop();
            }
            for (ConnectionManager requestConnectionManager : this.whisperAndShoutRequestConnectionManagers) {
                requestConnectionManager.close();
            }
            for (ConnectionManager requestConnectionManager : this.talkRequestConnectionManagers) {
                requestConnectionManager.close();
            }
            for (ResponseListener responseListener : this.responseListeners) {
                responseListener.close();
            }
            this.getCallbackMap().shutdown();
        }
    }
}

