/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.phalanx.wire.SignatureUtility;
import org.smallmind.phalanx.wire.TransportTimeoutException;
import org.smallmind.phalanx.wire.signal.ResultSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.TransmissionCallback;

public class AsynchronousTransmissionCallback
extends TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<ResultSignal> resultSignalRef = new AtomicReference();
    private final String serviceName;
    private final String functionName;

    public AsynchronousTransmissionCallback(String serviceName, String functionName) {
        this.serviceName = serviceName;
        this.functionName = functionName;
    }

    @Override
    public Object getResult(SignalCodec signalCodec, long timeoutSeconds) throws Throwable {
        if (!this.resultLatch.await(timeoutSeconds, TimeUnit.SECONDS)) {
            throw new TransportTimeoutException("The timeout(%d) seconds was exceeded while waiting for a response(%s.%s)", timeoutSeconds, this.serviceName, this.functionName);
        }
        ResultSignal resultSignal = this.resultSignalRef.get();
        if (resultSignal == null) {
            throw new IllegalStateException("Missing signal result");
        }
        this.handleError(signalCodec, resultSignal);
        return signalCodec.extractObject(resultSignal.getResult(), SignatureUtility.nativeDecode(resultSignal.getNativeType()));
    }

    public void setResultSignal(ResultSignal resultSignal) {
        this.resultSignalRef.set(resultSignal);
        this.resultLatch.countDown();
    }
}

